/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.IntegralGenerator;
import com.pholser.junit.quickcheck.internal.Comparables;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public class ByteGenerator
extends IntegralGenerator<Byte> {
    private byte min = (Byte)Reflection.defaultValueOf(InRange.class, "minByte");
    private byte max = (Byte)Reflection.defaultValueOf(InRange.class, "maxByte");

    public ByteGenerator() {
        super(Arrays.asList(Byte.class, Byte.TYPE));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minByte() : Byte.parseByte(range.min());
        this.max = range.max().isEmpty() ? range.maxByte() : Byte.parseByte(range.max());
    }

    @Override
    public Byte generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextByte(this.min, this.max);
    }

    @Override
    protected Function<BigInteger, Byte> narrow() {
        return Number::byteValue;
    }

    @Override
    protected Predicate<Byte> inRange() {
        return Comparables.inRange(this.min, this.max);
    }

    @Override
    protected Byte leastMagnitude() {
        return Comparables.leastMagnitude(this.min, this.max, (byte)0);
    }

    @Override
    protected boolean negative(Byte target) {
        return target < 0;
    }

    @Override
    protected Byte negate(Byte target) {
        return -target.byteValue();
    }

    @Override
    public BigDecimal magnitude(Object value) {
        return BigDecimal.valueOf(((Byte)this.narrow(value)).byteValue());
    }
}

