/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.java.lang.CodePointShrink;
import com.pholser.junit.quickcheck.internal.Comparables;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CharacterGenerator
extends Generator<Character> {
    private char min = ((Character)Reflection.defaultValueOf(InRange.class, "minChar")).charValue();
    private char max = ((Character)Reflection.defaultValueOf(InRange.class, "maxChar")).charValue();

    public CharacterGenerator() {
        super(Arrays.asList(Character.class, Character.TYPE));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minChar() : range.min().charAt(0);
        this.max = range.max().isEmpty() ? range.maxChar() : range.max().charAt(0);
    }

    @Override
    public Character generate(SourceOfRandomness random, GenerationStatus status) {
        return Character.valueOf(random.nextChar(this.min, this.max));
    }

    @Override
    public List<Character> doShrink(SourceOfRandomness random, Character larger) {
        return new CodePointShrink(cp -> cp >= this.min && cp <= this.max).shrink(random, larger.charValue()).stream().map((? super T cp) -> Character.valueOf((char)cp.intValue())).filter(this::inRange).collect(Collectors.toList());
    }

    @Override
    public BigDecimal magnitude(Object value) {
        return BigDecimal.valueOf(((Character)this.narrow(value)).charValue());
    }

    private boolean inRange(Character value) {
        return Comparables.inRange(Character.valueOf(this.min), Character.valueOf(this.max)).test(value);
    }
}

