/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class CodePointShrink
implements Shrink<Integer> {
    private final Predicate<? super Integer> filter;

    CodePointShrink(Predicate<? super Integer> filter) {
        this.filter = filter;
    }

    @Override
    public List<Integer> shrink(SourceOfRandomness random, Object larger) {
        int codePoint = (Integer)larger;
        ArrayList<Integer> shrinks = new ArrayList<Integer>();
        Collections.addAll(shrinks, 97, 98, 99);
        if (Character.isUpperCase(codePoint)) {
            shrinks.add(Character.toLowerCase(codePoint));
        }
        Collections.addAll(shrinks, 65, 66, 67, 49, 50, 51, 32, 10);
        Collections.reverse(shrinks);
        Comparator<Integer> comparator = Comparator.comparing(Character::isLowerCase).thenComparing(Character::isUpperCase).thenComparing(Character::isDigit).thenComparing(cp -> Integer.valueOf(32).equals(cp)).thenComparing(Character::isSpaceChar).thenComparing(Comparator.naturalOrder());
        return shrinks.stream().filter(this.filter).filter(cp -> comparator.compare((Integer)cp, codePoint) < 0).distinct().collect(Collectors.toList());
    }
}

