/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.DecimalGenerator;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Comparables;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public class DoubleGenerator
extends DecimalGenerator<Double> {
    private double min = (Double)Reflection.defaultValueOf(InRange.class, "minDouble");
    private double max = (Double)Reflection.defaultValueOf(InRange.class, "maxDouble");

    public DoubleGenerator() {
        super(Arrays.asList(Double.class, Double.TYPE));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minDouble() : Double.parseDouble(range.min());
        this.max = range.max().isEmpty() ? range.maxDouble() : Double.parseDouble(range.max());
    }

    @Override
    public Double generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextDouble(this.min, this.max);
    }

    @Override
    protected Function<Double, BigDecimal> widen() {
        return BigDecimal::valueOf;
    }

    @Override
    protected Function<BigDecimal, Double> narrow() {
        return BigDecimal::doubleValue;
    }

    @Override
    protected Predicate<Double> inRange() {
        return Comparables.inRange(this.min, this.max);
    }

    @Override
    protected Double leastMagnitude() {
        return Comparables.leastMagnitude(this.min, this.max, 0.0);
    }

    @Override
    protected boolean negative(Double target) {
        return target < 0.0;
    }

    @Override
    protected Double negate(Double target) {
        return -target.doubleValue();
    }

    @Override
    public BigDecimal magnitude(Object value) {
        return BigDecimal.valueOf((Double)this.narrow(value));
    }
}

