/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.DecimalGenerator;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Comparables;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public class FloatGenerator
extends DecimalGenerator<Float> {
    private float min = ((Float)Reflection.defaultValueOf(InRange.class, "minFloat")).floatValue();
    private float max = ((Float)Reflection.defaultValueOf(InRange.class, "maxFloat")).floatValue();

    public FloatGenerator() {
        super(Arrays.asList(Float.class, Float.TYPE));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minFloat() : Float.parseFloat(range.min());
        this.max = range.max().isEmpty() ? range.maxFloat() : Float.parseFloat(range.max());
    }

    @Override
    public Float generate(SourceOfRandomness random, GenerationStatus status) {
        return Float.valueOf(random.nextFloat(this.min, this.max));
    }

    @Override
    protected Function<Float, BigDecimal> widen() {
        return BigDecimal::valueOf;
    }

    @Override
    protected Function<BigDecimal, Float> narrow() {
        return BigDecimal::floatValue;
    }

    @Override
    protected Predicate<Float> inRange() {
        return Comparables.inRange(Float.valueOf(this.min), Float.valueOf(this.max));
    }

    @Override
    protected Float leastMagnitude() {
        return Comparables.leastMagnitude(Float.valueOf(this.min), Float.valueOf(this.max), Float.valueOf(0.0f));
    }

    @Override
    protected boolean negative(Float target) {
        return target.floatValue() < 0.0f;
    }

    @Override
    protected Float negate(Float target) {
        return Float.valueOf(-target.floatValue());
    }

    @Override
    public BigDecimal magnitude(Object value) {
        return BigDecimal.valueOf(((Float)this.narrow(value)).floatValue());
    }
}

