/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.lang;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.IntegralGenerator;
import com.pholser.junit.quickcheck.internal.Comparables;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public class IntegerGenerator
extends IntegralGenerator<Integer> {
    private int min = (Integer)Reflection.defaultValueOf(InRange.class, "minInt");
    private int max = (Integer)Reflection.defaultValueOf(InRange.class, "maxInt");

    public IntegerGenerator() {
        super(Arrays.asList(Integer.class, Integer.TYPE));
    }

    public void configure(InRange range) {
        this.min = range.min().isEmpty() ? range.minInt() : Integer.parseInt(range.min());
        this.max = range.max().isEmpty() ? range.maxInt() : Integer.parseInt(range.max());
    }

    @Override
    public Integer generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextInt(this.min, this.max);
    }

    @Override
    protected Function<BigInteger, Integer> narrow() {
        return BigInteger::intValue;
    }

    @Override
    protected Predicate<Integer> inRange() {
        return Comparables.inRange(this.min, this.max);
    }

    @Override
    protected Integer leastMagnitude() {
        return Comparables.leastMagnitude(this.min, this.max, 0);
    }

    @Override
    protected boolean negative(Integer target) {
        return target < 0;
    }

    @Override
    protected Integer negate(Integer target) {
        return -target.intValue();
    }

    @Override
    public BigDecimal magnitude(Object value) {
        return BigDecimal.valueOf(((Integer)this.narrow(value)).intValue());
    }
}

