/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.Instant;

public class InstantGenerator
extends Generator<Instant> {
    private Instant min = Instant.MIN;
    private Instant max = Instant.MAX;

    public InstantGenerator() {
        super(Instant.class);
    }

    public void configure(InRange range) {
        if (!Reflection.defaultValueOf(InRange.class, "min").equals(range.min())) {
            this.min = Instant.parse(range.min());
        }
        if (!Reflection.defaultValueOf(InRange.class, "max").equals(range.max())) {
            this.max = Instant.parse(range.max());
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    @Override
    public Instant generate(SourceOfRandomness random, GenerationStatus status) {
        return random.nextInstant(this.min, this.max);
    }
}

