/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateGenerator
extends Generator<LocalDate> {
    private LocalDate min = LocalDate.MIN;
    private LocalDate max = LocalDate.MAX;

    public LocalDateGenerator() {
        super(LocalDate.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, "min").equals(range.min())) {
            this.min = LocalDate.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, "max").equals(range.max())) {
            this.max = LocalDate.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    @Override
    public LocalDate generate(SourceOfRandomness random, GenerationStatus status) {
        return LocalDate.ofEpochDay(random.nextLong(this.min.toEpochDay(), this.max.toEpochDay()));
    }
}

