/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;

public class MonthDayGenerator
extends Generator<MonthDay> {
    private MonthDay min = MonthDay.of(1, 1);
    private MonthDay max = MonthDay.of(12, 31);

    public MonthDayGenerator() {
        super(MonthDay.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, "min").equals(range.min())) {
            this.min = MonthDay.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, "max").equals(range.max())) {
            this.max = MonthDay.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    @Override
    public MonthDay generate(SourceOfRandomness random, GenerationStatus status) {
        long minEpochDay = this.min.atYear(2000).toEpochDay();
        long maxEpochDay = this.max.atYear(2000).toEpochDay();
        LocalDate date = LocalDate.ofEpochDay(random.nextLong(minEpochDay, maxEpochDay));
        return MonthDay.of(date.getMonthValue(), date.getDayOfMonth());
    }
}

