/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.Year;
import java.time.format.DateTimeFormatter;

public class YearGenerator
extends Generator<Year> {
    private Year min = Year.of(-999999999);
    private Year max = Year.of(999999999);

    public YearGenerator() {
        super(Year.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, "min").equals(range.min())) {
            this.min = Year.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, "max").equals(range.max())) {
            this.max = Year.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    @Override
    public Year generate(SourceOfRandomness random, GenerationStatus status) {
        return Year.of(random.nextInt(this.min.getValue(), this.max.getValue()));
    }
}

