/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.ZoneOffset;

public class ZoneOffsetGenerator
extends Generator<ZoneOffset> {
    private ZoneOffset min = ZoneOffset.MAX;
    private ZoneOffset max = ZoneOffset.MIN;

    public ZoneOffsetGenerator() {
        super(ZoneOffset.class);
    }

    public void configure(InRange range) {
        if (!Reflection.defaultValueOf(InRange.class, "min").equals(range.min())) {
            this.min = ZoneOffset.of(range.min());
        }
        if (!Reflection.defaultValueOf(InRange.class, "max").equals(range.max())) {
            this.max = ZoneOffset.of(range.max());
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", this.min, this.max));
        }
    }

    @Override
    public ZoneOffset generate(SourceOfRandomness random, GenerationStatus status) {
        int maxSeconds;
        int minSeconds = this.min.getTotalSeconds();
        return ZoneOffset.ofTotalSeconds(minSeconds <= (maxSeconds = this.max.getTotalSeconds()) ? random.nextInt(minSeconds, maxSeconds) : random.nextInt(maxSeconds, minSeconds));
    }
}

