/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.ComponentizedGenerator;
import com.pholser.junit.quickcheck.generator.Distinct;
import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.generator.Size;
import com.pholser.junit.quickcheck.internal.Lists;
import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Sequences;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class CollectionGenerator<T extends Collection>
extends ComponentizedGenerator<T> {
    private Size sizeRange;
    private boolean distinct;

    protected CollectionGenerator(Class<T> type) {
        super(type);
    }

    public void configure(Size size) {
        this.sizeRange = size;
        Ranges.checkRange(Ranges.Type.INTEGRAL, size.min(), size.max());
    }

    public void configure(Distinct distinct) {
        this.setDistinct(distinct != null);
    }

    protected final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public T generate(SourceOfRandomness random, GenerationStatus status) {
        int size = this.size(random, status);
        Generator<?> generator = this.componentGenerators().get(0);
        Stream itemStream = (Stream)Stream.generate(() -> generator.generate(random, status)).sequential();
        if (this.distinct) {
            itemStream = itemStream.distinct();
        }
        T items = this.empty();
        itemStream.limit(size).forEach(arg_0 -> items.add(arg_0));
        return items;
    }

    @Override
    public List<T> doShrink(SourceOfRandomness random, T larger) {
        ArrayList asList = new ArrayList(larger);
        ArrayList<T> shrinks = new ArrayList<T>(this.removals(asList));
        Shrink generator = this.componentGenerators().get(0);
        Stream<Object> oneItemShrinks = Lists.shrinksOfOneItem(random, asList, generator).stream();
        if (this.distinct) {
            oneItemShrinks = oneItemShrinks.filter(Lists::isDistinct);
        }
        shrinks.addAll(oneItemShrinks.map(this::convert).filter(this::inSizeRange).collect(Collectors.toList()));
        return shrinks;
    }

    @Override
    public int numberOfNeededComponents() {
        return 1;
    }

    @Override
    public BigDecimal magnitude(Object value) {
        Collection narrowed = (Collection)this.narrow(value);
        if (narrowed.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal elementsMagnitude = narrowed.stream().map((? super T e) -> this.componentGenerators().get(0).magnitude(e)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return BigDecimal.valueOf(narrowed.size()).multiply(elementsMagnitude);
    }

    protected final T empty() {
        return (T)((Collection)Reflection.instantiate(Reflection.findConstructor(this.types().get(0), new Class[0]), new Object[0]));
    }

    private boolean inSizeRange(T items) {
        return this.sizeRange == null || items.size() >= this.sizeRange.min() && items.size() <= this.sizeRange.max();
    }

    private int size(SourceOfRandomness random, GenerationStatus status) {
        return this.sizeRange != null ? random.nextInt(this.sizeRange.min(), this.sizeRange.max()) : status.size();
    }

    private List<T> removals(List<?> items) {
        return StreamSupport.stream(Sequences.halving(items.size()).spliterator(), false).map((? super T i) -> Lists.removeFrom(items, i)).flatMap(Collection::stream).map(this::convert).filter(this::inSizeRange).collect(Collectors.toList());
    }

    private T convert(List<?> items) {
        T converted = this.empty();
        converted.addAll(items);
        return converted;
    }
}

