/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.generator.java.lang.IntegerGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class OptionalIntGenerator
extends Generator<OptionalInt> {
    private final IntegerGenerator integers = new IntegerGenerator();

    public OptionalIntGenerator() {
        super(OptionalInt.class);
    }

    public void configure(InRange range) {
        this.integers.configure(range);
    }

    @Override
    public OptionalInt generate(SourceOfRandomness random, GenerationStatus status) {
        double trial = random.nextDouble();
        return trial < 0.25 ? OptionalInt.empty() : OptionalInt.of(this.integers.generate(random, status));
    }

    @Override
    public List<OptionalInt> doShrink(SourceOfRandomness random, OptionalInt larger) {
        if (!larger.isPresent()) {
            return new ArrayList<OptionalInt>();
        }
        ArrayList<OptionalInt> shrinks = new ArrayList<OptionalInt>();
        shrinks.add(OptionalInt.empty());
        shrinks.addAll(this.integers.shrink(random, larger.getAsInt()).stream().map(OptionalInt::of).collect(Collectors.toList()));
        return shrinks;
    }

    @Override
    public BigDecimal magnitude(Object value) {
        OptionalInt narrowed = (OptionalInt)this.narrow(value);
        return narrowed.isPresent() ? BigDecimal.valueOf(narrowed.getAsInt()) : BigDecimal.ZERO;
    }
}

