/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.constraint;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class ConstraintEvaluator {
    private final Object constraint;
    private final OgnlContext bindings;

    public ConstraintEvaluator(String expression) {
        try {
            this.constraint = expression == null ? null : Ognl.parseExpression(expression);
            this.bindings = new ConstraintOgnlContext();
        }
        catch (OgnlException ex) {
            throw new EvaluationException(ex);
        }
    }

    public boolean evaluate() {
        try {
            return this.constraint == null || (Boolean)Ognl.getValue(this.constraint, (Map)this.bindings, null) != false;
        }
        catch (OgnlException ex) {
            throw new EvaluationException(ex);
        }
    }

    public void bind(Object value) {
        this.bindings.put("_", value);
    }

    private static class ConstraintOgnlContext
    extends OgnlContext {
        private ConstraintOgnlContext() {
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                throw new EvaluationException("Referring to undefined variable '" + key + "']");
            }
            return super.get(key);
        }
    }

    public static class EvaluationException
    extends RuntimeException {
        private static final long serialVersionUID = Integer.MIN_VALUE;

        EvaluationException(String message) {
            super(message);
        }

        EvaluationException(Throwable cause) {
            super(cause);
        }
    }
}

