/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.ServiceLoaderGeneratorSource;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheckTestClass;
import com.pholser.junit.quickcheck.runner.PropertyStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitQuickcheck
extends BlockJUnit4ClassRunner {
    private final GeneratorRepository repo;
    private final GeometricDistribution distro;
    private final Logger logger;

    public JUnitQuickcheck(Class<?> clazz) throws InitializationError {
        super(new JUnitQuickcheckTestClass(clazz));
        SourceOfRandomness random = new SourceOfRandomness(new Random());
        this.repo = new GeneratorRepository(random).register(new ServiceLoaderGeneratorSource());
        this.distro = new GeometricDistribution();
        this.logger = LoggerFactory.getLogger((String)"junit-quickcheck.value-reporting");
    }

    @Override
    protected void validateTestMethods(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(Test.class, false, errors);
        this.validatePropertyMethods(errors);
    }

    private void validatePropertyMethods(List<Throwable> errors) {
        this.getTestClass().getAnnotatedMethods(Property.class).forEach(m -> m.validatePublicVoid(false, errors));
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> methods = new ArrayList<FrameworkMethod>();
        methods.addAll(this.getTestClass().getAnnotatedMethods(Test.class));
        methods.addAll(this.getTestClass().getAnnotatedMethods(Property.class));
        return methods;
    }

    @Override
    public Statement methodBlock(FrameworkMethod method) {
        return method.getAnnotation(Test.class) != null ? super.methodBlock(method) : new PropertyStatement(method, this.getTestClass(), this.repo, this.distro, this.logger);
    }
}

