/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

class PropertyVerifier
extends BlockJUnit4ClassRunner {
    private final FrameworkMethod method;
    private final Object[] args;
    private final long[] seeds;
    private final Consumer<Void> onSuccess;
    private final Consumer<AssumptionViolatedException> onAssumptionViolated;
    private final BiConsumer<AssertionError, Runnable> onFailure;

    PropertyVerifier(TestClass clazz, FrameworkMethod method, Object[] args, long[] seeds, Consumer<Void> onSuccess, Consumer<AssumptionViolatedException> onAssumptionViolated, BiConsumer<AssertionError, Runnable> onFailure) throws InitializationError {
        super(clazz.getJavaClass());
        this.method = method;
        this.args = args;
        this.seeds = seeds;
        this.onSuccess = onSuccess;
        this.onAssumptionViolated = onAssumptionViolated;
        this.onFailure = onFailure;
    }

    void verify() throws Throwable {
        this.methodBlock().evaluate();
    }

    private Statement methodBlock() {
        final Statement statement = super.methodBlock(this.method);
        return new Statement(){

            @Override
            public void evaluate() {
                try {
                    statement.evaluate();
                    PropertyVerifier.this.onSuccess.accept(null);
                }
                catch (AssumptionViolatedException e) {
                    PropertyVerifier.this.onAssumptionViolated.accept(e);
                }
                catch (AssertionError e) {
                    Runnable repeat = () -> {
                        try {
                            statement.evaluate();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    };
                    PropertyVerifier.this.onFailure.accept(e, repeat);
                }
                catch (Throwable t) {
                    PropertyVerifier.this.reportErrorWithArguments(t);
                }
            }
        };
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    @Override
    protected Statement methodInvoker(final FrameworkMethod frameworkMethod, final Object test) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                frameworkMethod.invokeExplosively(test, PropertyVerifier.this.args);
            }
        };
    }

    private void reportErrorWithArguments(Throwable e) {
        throw new AssertionError(String.format("Unexpected error in property %s with args %s and seeds %s", this.method.getName(), Arrays.deepToString(this.args), Arrays.toString(this.seeds)), e);
    }
}

