/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.Weighted;
import org.apache.beam.sdk.util.WeightedValue;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CachesTest {
    private static final long MB = 0x100000L;

    @Test
    public void testNoopCache() throws Exception {
        Cache cache = Caches.noop();
        cache.put((Object)"key", (Object)"value");
        Assert.assertNull(cache.peek((Object)"key"));
        Assert.assertEquals("value", cache.computeIfAbsent((Object)"key", unused -> "value"));
        Assert.assertNull(cache.peek((Object)"key"));
    }

    @Test
    public void testShrinkableIsShrunk() throws Exception {
        WeightedValue shrinkableKey = WeightedValue.of((Object)"shrinkable", (long)0x100000L);
        Cache.Shrinkable<Object> shrinkable = new Cache.Shrinkable<Object>(){

            public Object shrink() {
                return WeightedValue.of((Object)"wasShrunk", (long)1L);
            }
        };
        Cache cache = Caches.forMaximumBytes((long)0x200000L);
        cache.put((Object)shrinkableKey, (Object)WeightedValue.of((Object)shrinkable, (long)0x100000L));
        Assert.assertSame(shrinkable, cache.peek((Object)shrinkableKey));
        cache.put((Object)WeightedValue.of((Object)"other", (long)1L), (Object)WeightedValue.of((Object)"value", (long)1L));
        Assert.assertEquals("wasShrunk", cache.peek((Object)shrinkableKey));
    }

    @Test
    public void testEternalCache() throws Exception {
        this.testCache((Cache<String, String>)Caches.eternal());
    }

    @Test
    public void testDefaultCache() throws Exception {
        this.testCache((Cache<String, String>)Caches.fromOptions((PipelineOptions)PipelineOptionsFactory.create()));
    }

    @Test
    public void testSubCache() throws Exception {
        this.testCache((Cache<String, String>)Caches.subCache((Cache)Caches.eternal(), (Object)"prefix", (Object[])new Object[0]));
    }

    @Test
    public void testSiblingSubCaches() throws Exception {
        Cache parent = Caches.eternal();
        Cache cacheA = Caches.subCache((Cache)parent, (Object)"prefixA", (Object[])new Object[0]);
        Cache cacheACopy = Caches.subCache((Cache)parent, (Object)"prefixA", (Object[])new Object[0]);
        Cache cacheB = Caches.subCache((Cache)parent, (Object)"prefixB", (Object[])new Object[0]);
        cacheA.put((Object)"keyA", (Object)"valueA");
        Assert.assertEquals("valueA", cacheA.peek((Object)"keyA"));
        Assert.assertEquals("valueA", cacheACopy.peek((Object)"keyA"));
        Assert.assertNull(cacheB.peek((Object)"keyA"));
    }

    @Test
    public void testNestedSubCaches() throws Exception {
        Cache parent = Caches.eternal();
        Cache child = Caches.subCache((Cache)parent, (Object)"child", (Object[])new Object[0]);
        Cache childOfChild = Caches.subCache((Cache)child, (Object)"childOfChild", (Object[])new Object[0]);
        child.put((Object)"keyA", (Object)"childA");
        childOfChild.put((Object)"keyA", (Object)"childOfChildA");
        Assert.assertEquals("childA", child.peek((Object)"keyA"));
        Assert.assertEquals("childOfChildA", childOfChild.peek((Object)"keyA"));
        child.computeIfAbsent((Object)"keyB", unused -> "childB");
        childOfChild.computeIfAbsent((Object)"keyB", unused -> "childOfChildB");
        Assert.assertEquals("childB", child.peek((Object)"keyB"));
        Assert.assertEquals("childOfChildB", childOfChild.peek((Object)"keyB"));
        child.remove((Object)"keyA");
        Assert.assertNull(child.peek((Object)"keyA"));
        Assert.assertEquals("childOfChildA", childOfChild.peek((Object)"keyA"));
        childOfChild.remove((Object)"keyB");
        Assert.assertEquals("childB", child.peek((Object)"keyB"));
        Assert.assertNull(childOfChild.peek((Object)"keyB"));
    }

    @Test
    public void testClearableCache() {
        Caches.ClearableCache cache = new Caches.ClearableCache(Caches.eternal());
        this.testCache((Cache<String, String>)cache);
        this.testCache((Cache<String, String>)Caches.subCache((Cache)cache, (Object)"clearableChild", (Object[])new Object[0]));
    }

    @Test
    public void testClearableCacheClearing() {
        Cache parent = Caches.eternal();
        Caches.ClearableCache cache = new Caches.ClearableCache(parent);
        parent.put((Object)"untracked", (Object)"untrackedValue");
        parent.put((Object)"tracked", (Object)"parentValue");
        cache.put((Object)"tracked", (Object)"parentValueNowTracked");
        cache.computeIfAbsent((Object)"tracked2", unused -> "trackedValue2");
        cache.clear();
        Assert.assertNull(parent.peek((Object)"tracked"));
        Assert.assertNull(parent.peek((Object)"tracked2"));
        Assert.assertEquals("untrackedValue", parent.peek((Object)"untracked"));
    }

    private void testCache(Cache<String, String> cache) {
        Assert.assertNull(cache.peek((Object)"key1"));
        cache.put((Object)"key1", (Object)"value1");
        Assert.assertEquals("value1", cache.peek((Object)"key1"));
        Assert.assertEquals("value1", cache.computeIfAbsent((Object)"key1", unused -> "anotherValue"));
        Assert.assertEquals("value1", cache.peek((Object)"key1"));
        Assert.assertEquals("value2", cache.computeIfAbsent((Object)"key2", unused -> "value2"));
        Assert.assertEquals("value2", cache.peek((Object)"key2"));
    }

    @Test
    public void testDescribeStats() throws Exception {
        Cache cache = Caches.forMaximumBytes((long)1048576000L);
        for (int i = 0; i < 100; ++i) {
            cache.computeIfAbsent((Object)WeightedValue.of((Object)i, (long)0x100000L), key -> new ShrinkableString("value", 0x200000L));
            cache.peek((Object)WeightedValue.of((Object)i, (long)0x100000L));
            cache.put((Object)WeightedValue.of((Object)(100 + i), (long)0x100000L), (Object)new ShrinkableString("value", 0x200000L));
        }
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("used/max 600/1000 MB"));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.anyOf(Matchers.containsString("hit 50.00%"), Matchers.containsString("hit 50,00%")));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("lookups 200"));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("avg load time"));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("loads 100"));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("evictions 0"));
        cache.put((Object)WeightedValue.of((Object)1000, (long)0x6400000L), (Object)new ShrinkableString("value", 943718400L));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("used/max 1000/1000 MB"));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("evictions 200"));
        cache.put((Object)WeightedValue.of((Object)1001, (long)0x100000L), (Object)new ShrinkableString("value", 0x3700000L));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("used/max 606/1000 MB"));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("evictions 201"));
        Caches.subCache((Cache)cache, (Object)WeightedValue.of((Object)"subCache", (long)0x2100000L), (Object[])new Object[0]).put((Object)WeightedValue.of((Object)"subCacheKey", (long)0x800000L), (Object)WeightedValue.of((Object)"subCacheValue", (long)0x300000L));
        MatcherAssert.assertThat(cache.describeStats(), Matchers.containsString("used/max 650/1000 MB"));
    }

    private static class ShrinkableString
    implements Cache.Shrinkable<ShrinkableString>,
    Weighted {
        private final String value;
        private final long weight;

        public ShrinkableString(String value, long weight) {
            this.value = value;
            this.weight = weight;
        }

        public ShrinkableString shrink() {
            if (this.weight < 0x32000000L) {
                return null;
            }
            return new ShrinkableString(this.value, this.weight / 2L);
        }

        public long getWeight() {
            return this.weight;
        }
    }
}

