/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.beam.fn.harness.MapFnRunners;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.PTransformRunnerFactoryTestContext;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.CoderTranslation;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MapFnRunnersTest {
    private static final String EXPECTED_ID = "pTransformId";
    private static final RunnerApi.PTransform EXPECTED_PTRANSFORM = RunnerApi.PTransform.newBuilder().putInputs("input", "inputPC").putOutputs("output", "outputPC").build();
    private static final RunnerApi.PCollection INPUT_PCOLLECTION = RunnerApi.PCollection.newBuilder().setUniqueName("inputPC").setCoderId("coder-id").build();
    private static RunnerApi.Coder valueCoder;

    @Test
    public void testValueOnlyMapping() throws Exception {
        PTransformRunnerFactoryTestContext context = PTransformRunnerFactoryTestContext.builder(EXPECTED_ID, EXPECTED_PTRANSFORM).processBundleInstructionId("57").components(RunnerApi.Components.newBuilder().putAllPcollections(Collections.singletonMap("inputPC", INPUT_PCOLLECTION)).putAllCoders(Collections.singletonMap("coder-id", valueCoder)).build()).build();
        ArrayList outputConsumer = new ArrayList();
        context.addPCollectionConsumer("outputPC", outputConsumer::add);
        MapFnRunners.ValueMapFnFactory factory = (ptId, pt) -> String::toUpperCase;
        MapFnRunners.forValueMapFnFactory((MapFnRunners.ValueMapFnFactory)factory).createRunnerForPTransform((PTransformRunnerFactory.Context)context);
        MatcherAssert.assertThat(context.getStartBundleFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getFinishBundleFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getTearDownFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getPCollectionConsumers().keySet(), Matchers.containsInAnyOrder("inputPC", "outputPC"));
        context.getPCollectionConsumer("inputPC").accept((Object)WindowedValue.valueInGlobalWindow((Object)"abc"));
        MatcherAssert.assertThat(outputConsumer, Matchers.contains(WindowedValue.valueInGlobalWindow((Object)"ABC")));
    }

    @Test
    public void testFullWindowedValueMapping() throws Exception {
        PTransformRunnerFactoryTestContext context = PTransformRunnerFactoryTestContext.builder(EXPECTED_ID, EXPECTED_PTRANSFORM).processBundleInstructionId("57").components(RunnerApi.Components.newBuilder().putAllPcollections(Collections.singletonMap("inputPC", INPUT_PCOLLECTION)).putAllCoders(Collections.singletonMap("coder-id", valueCoder)).build()).build();
        ArrayList outputConsumer = new ArrayList();
        context.addPCollectionConsumer("outputPC", outputConsumer::add);
        MapFnRunners.forWindowedValueMapFnFactory(this::createMapFunctionForPTransform).createRunnerForPTransform((PTransformRunnerFactory.Context)context);
        MatcherAssert.assertThat(context.getStartBundleFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getFinishBundleFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getTearDownFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getPCollectionConsumers().keySet(), Matchers.containsInAnyOrder("inputPC", "outputPC"));
        context.getPCollectionConsumer("inputPC").accept((Object)WindowedValue.valueInGlobalWindow((Object)"abc"));
        MatcherAssert.assertThat(outputConsumer, Matchers.contains(WindowedValue.valueInGlobalWindow((Object)"ABC")));
    }

    @Test
    public void testFullWindowedValueMappingWithCompressedWindow() throws Exception {
        PTransformRunnerFactoryTestContext context = PTransformRunnerFactoryTestContext.builder(EXPECTED_ID, EXPECTED_PTRANSFORM).processBundleInstructionId("57").components(RunnerApi.Components.newBuilder().putAllPcollections(Collections.singletonMap("inputPC", INPUT_PCOLLECTION)).putAllCoders(Collections.singletonMap("coder-id", valueCoder)).build()).build();
        ArrayList outputConsumer = new ArrayList();
        context.addPCollectionConsumer("outputPC", outputConsumer::add);
        MapFnRunners.forWindowedValueMapFnFactory(this::createMapFunctionForPTransform).createRunnerForPTransform((PTransformRunnerFactory.Context)context);
        MatcherAssert.assertThat(context.getStartBundleFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getFinishBundleFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getTearDownFunctions(), Matchers.empty());
        MatcherAssert.assertThat(context.getPCollectionConsumers().keySet(), Matchers.containsInAnyOrder("inputPC", "outputPC"));
        IntervalWindow firstWindow = new IntervalWindow(new Instant(0L), (ReadableDuration)Duration.standardMinutes((long)10L));
        IntervalWindow secondWindow = new IntervalWindow(new Instant(-10L), (ReadableDuration)Duration.standardSeconds((long)22L));
        context.getPCollectionConsumer("inputPC").accept((Object)WindowedValue.of((Object)"abc", (Instant)new Instant(12L), (Collection)ImmutableSet.of((Object)firstWindow, (Object)GlobalWindow.INSTANCE, (Object)secondWindow), (PaneInfo)PaneInfo.NO_FIRING));
        MatcherAssert.assertThat(outputConsumer, Matchers.containsInAnyOrder(WindowedValue.timestampedValueInGlobalWindow((Object)"ABC", (Instant)new Instant(12L)), WindowedValue.of((Object)"ABC", (Instant)new Instant(12L), (BoundedWindow)secondWindow, (PaneInfo)PaneInfo.NO_FIRING), WindowedValue.of((Object)"ABC", (Instant)new Instant(12L), (BoundedWindow)firstWindow, (PaneInfo)PaneInfo.NO_FIRING)));
    }

    public ThrowingFunction<WindowedValue<String>, WindowedValue<String>> createMapFunctionForPTransform(String ptransformId, RunnerApi.PTransform pTransform) {
        Assert.assertEquals(EXPECTED_ID, ptransformId);
        Assert.assertEquals(EXPECTED_PTRANSFORM, pTransform);
        return str -> str.withValue((Object)((String)str.getValue()).toUpperCase());
    }

    static {
        try {
            valueCoder = CoderTranslation.toProto((Coder)StringUtf8Coder.of()).getCoder();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

