/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.beam.fn.harness.AutoValue_PTransformRunnerFactoryTestContext;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.control.BundleProgressReporter;
import org.apache.beam.fn.harness.control.BundleSplitListener;
import org.apache.beam.fn.harness.data.BeamFnDataClient;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.BeamFnDataOutboundAggregator;
import org.apache.beam.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.sdk.fn.data.DataEndpoint;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.data.TimerEndpoint;
import org.apache.beam.sdk.function.ThrowingRunnable;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.util.construction.Timer;
import org.joda.time.Instant;

@AutoValue
public abstract class PTransformRunnerFactoryTestContext
implements PTransformRunnerFactory.Context {
    public static Builder builder(String pTransformId, RunnerApi.PTransform pTransform) {
        return new AutoValue_PTransformRunnerFactoryTestContext.Builder().pipelineOptions(PipelineOptionsFactory.create()).shortIdMap(new ShortIdMap()).beamFnDataClient(new BeamFnDataClient(){

            public void registerReceiver(String instructionId, List<Endpoints.ApiServiceDescriptor> apiServiceDescriptors, CloseableFnDataReceiver<BeamFnApi.Elements> receiver) {
                throw new UnsupportedOperationException("Unexpected call during test.");
            }

            public void unregisterReceiver(String instructionId, List<Endpoints.ApiServiceDescriptor> apiServiceDescriptors) {
                throw new UnsupportedOperationException("Unexpected call during test.");
            }

            public BeamFnDataOutboundAggregator createOutboundAggregator(Endpoints.ApiServiceDescriptor apiServiceDescriptor, Supplier<String> processBundleRequestIdSupplier, boolean collectElementsIfNoFlushes) {
                throw new UnsupportedOperationException("Unexpected call during test.");
            }

            public void poisonInstructionId(String instructionId) {
                throw new UnsupportedOperationException("Unexpected call during test.");
            }
        }).beamFnStateClient(new BeamFnStateClient(){

            public CompletableFuture<BeamFnApi.StateResponse> handle(BeamFnApi.StateRequest.Builder requestBuilder) {
                throw new UnsupportedOperationException("Unexpected call during test.");
            }
        }).pTransformId(pTransformId).pTransform(pTransform).processBundleInstructionIdSupplier(() -> {
            throw new UnsupportedOperationException("Unexpected call during test.");
        }).cacheTokensSupplier(() -> Collections.emptyList()).bundleCacheSupplier(() -> Caches.noop()).processWideCache(Caches.noop()).components(RunnerApi.Components.newBuilder().putAllCoders(Collections.emptyMap()).putAllEnvironments(Collections.emptyMap()).putAllWindowingStrategies(Collections.emptyMap()).putAllPcollections(Collections.emptyMap()).build()).pCollectionConsumers(new HashMap()).startBundleFunctions(new ArrayList<ThrowingRunnable>()).finishBundleFunctions(new ArrayList<ThrowingRunnable>()).resetFunctions(new ArrayList<ThrowingRunnable>()).tearDownFunctions(new ArrayList<ThrowingRunnable>()).bundleProgressReporters(new ArrayList<BundleProgressReporter>()).incomingDataEndpoints(new HashMap()).incomingTimerEndpoints(new ArrayList()).outgoingDataEndpoints(new HashMap()).outgoingTimersEndpoints(new ArrayList()).outboundAggregators(new HashMap<Endpoints.ApiServiceDescriptor, BeamFnDataOutboundAggregator>()).timerApiServiceDescriptor(Endpoints.ApiServiceDescriptor.getDefaultInstance()).splitListener(new BundleSplitListener(){

            public void split(List<BeamFnApi.BundleApplication> primaryRoots, List<BeamFnApi.DelayedBundleApplication> residualRoots) {
                throw new UnsupportedOperationException("Unexpected call during test.");
            }
        }).bundleFinalizer(new DoFn.BundleFinalizer(){

            public void afterBundleCommit(Instant callbackExpiry, DoFn.BundleFinalizer.Callback callback) {
                throw new UnsupportedOperationException("Unexpected call during test.");
            }
        }).runnerCapabilities(new HashSet<String>());
    }

    public abstract Map<String, List<FnDataReceiver<?>>> getPCollectionConsumers();

    public <T> void addPCollectionConsumer(String pCollectionId, FnDataReceiver<WindowedValue<T>> consumer) {
        this.getPCollectionConsumers().computeIfAbsent(pCollectionId, unused -> new ArrayList()).add(consumer);
    }

    public <T> FnDataReceiver<T> getPCollectionConsumer(String pCollectionId) {
        final List<FnDataReceiver<?>> receivers = this.getPCollectionConsumers().get(pCollectionId);
        if (receivers == null) {
            throw new IllegalStateException("No consumers registered for " + pCollectionId);
        }
        if (receivers.size() == 1) {
            return receivers.get(0);
        }
        return new FnDataReceiver<T>(){

            public void accept(T input) throws Exception {
                for (FnDataReceiver receiver : receivers) {
                    receiver.accept(input);
                }
            }
        };
    }

    public abstract Map<Endpoints.ApiServiceDescriptor, List<DataEndpoint<?>>> getIncomingDataEndpoints();

    public <T> void addIncomingDataEndpoint(Endpoints.ApiServiceDescriptor apiServiceDescriptor, Coder<T> coder, FnDataReceiver<T> receiver) {
        this.getIncomingDataEndpoints().computeIfAbsent(apiServiceDescriptor, unused -> new ArrayList()).add(DataEndpoint.create((String)this.getPTransformId(), coder, receiver));
    }

    public abstract List<TimerEndpoint<?>> getIncomingTimerEndpoints();

    public <T> TimerEndpoint<T> getIncomingTimerEndpoint(String timerFamilyId) {
        for (TimerEndpoint<?> timerEndpoint : this.getIncomingTimerEndpoints()) {
            if (!timerFamilyId.equals(timerEndpoint.getTimerFamilyId())) continue;
            return timerEndpoint;
        }
        throw new NoSuchElementException();
    }

    public <T> void addIncomingTimerEndpoint(String timerFamilyId, Coder<Timer<T>> coder, FnDataReceiver<Timer<T>> receiver) {
        this.getIncomingTimerEndpoints().add(TimerEndpoint.create((String)this.getPTransformId(), (String)timerFamilyId, coder, receiver));
    }

    public abstract Map<Endpoints.ApiServiceDescriptor, BeamFnDataOutboundAggregator> getOutboundAggregators();

    public void addOutboundAggregator(Endpoints.ApiServiceDescriptor apiServiceDescriptor, BeamFnDataOutboundAggregator aggregator) {
        this.getOutboundAggregators().put(apiServiceDescriptor, aggregator);
    }

    public abstract Map<Endpoints.ApiServiceDescriptor, List<DataEndpoint<?>>> getOutgoingDataEndpoints();

    public <T> FnDataReceiver<T> addOutgoingDataEndpoint(Endpoints.ApiServiceDescriptor apiServiceDescriptor, Coder<T> coder) {
        BeamFnDataOutboundAggregator aggregator = this.getOutboundAggregators().get(apiServiceDescriptor);
        FnDataReceiver receiver = aggregator.registerOutputDataLocation(this.getPTransformId(), coder);
        this.getOutgoingDataEndpoints().computeIfAbsent(apiServiceDescriptor, unused -> new ArrayList()).add(DataEndpoint.create((String)this.getPTransformId(), coder, (FnDataReceiver)receiver));
        return receiver;
    }

    public abstract List<TimerEndpoint<?>> getOutgoingTimersEndpoints();

    public <T> TimerEndpoint<T> getOutgoingTimersEndpoint(String timerFamilyId) {
        for (TimerEndpoint<?> timerEndpoint : this.getOutgoingTimersEndpoints()) {
            if (!timerFamilyId.equals(timerEndpoint.getTimerFamilyId())) continue;
            return timerEndpoint;
        }
        throw new NoSuchElementException();
    }

    public <T> FnDataReceiver<Timer<T>> addOutgoingTimersEndpoint(String timerFamilyId, Coder<Timer<T>> coder) {
        BeamFnDataOutboundAggregator aggregator = this.getOutboundAggregators().get(this.getTimerApiServiceDescriptor());
        FnDataReceiver receiver = aggregator.registerOutputTimersLocation(this.getPTransformId(), timerFamilyId, coder);
        this.getOutgoingTimersEndpoints().add(TimerEndpoint.create((String)this.getPTransformId(), (String)timerFamilyId, coder, (FnDataReceiver)receiver));
        return receiver;
    }

    public abstract Endpoints.ApiServiceDescriptor getTimerApiServiceDescriptor();

    public abstract List<ThrowingRunnable> getStartBundleFunctions();

    public void addStartBundleFunction(ThrowingRunnable startBundleFunction) {
        this.getStartBundleFunctions().add(startBundleFunction);
    }

    public abstract List<ThrowingRunnable> getFinishBundleFunctions();

    public void addFinishBundleFunction(ThrowingRunnable finishBundleFunction) {
        this.getFinishBundleFunctions().add(finishBundleFunction);
    }

    public abstract List<ThrowingRunnable> getResetFunctions();

    public void addResetFunction(ThrowingRunnable resetFunction) {
        this.getResetFunctions().add(resetFunction);
    }

    public abstract List<ThrowingRunnable> getTearDownFunctions();

    public void addTearDownFunction(ThrowingRunnable tearDownFunction) {
        this.getTearDownFunctions().add(tearDownFunction);
    }

    public abstract List<BundleProgressReporter> getBundleProgressReporters();

    public void addBundleProgressReporter(BundleProgressReporter bundleProgressReporter) {
        this.getBundleProgressReporters().add(bundleProgressReporter);
    }

    @AutoValue.Builder
    public static interface Builder {
        public Builder pipelineOptions(PipelineOptions var1);

        public Builder shortIdMap(ShortIdMap var1);

        public Builder beamFnDataClient(BeamFnDataClient var1);

        public Builder beamFnStateClient(BeamFnStateClient var1);

        public Builder pTransformId(String var1);

        public Builder pTransform(RunnerApi.PTransform var1);

        public Builder processBundleInstructionIdSupplier(Supplier<String> var1);

        public Builder cacheTokensSupplier(Supplier<List<BeamFnApi.ProcessBundleRequest.CacheToken>> var1);

        public Builder bundleCacheSupplier(Supplier<Cache<?, ?>> var1);

        public Builder processWideCache(Cache<?, ?> var1);

        default public Builder processBundleInstructionId(String value) {
            return this.processBundleInstructionIdSupplier(() -> value);
        }

        public Builder components(RunnerApi.Components var1);

        public Builder runnerCapabilities(Set<String> var1);

        public Builder pCollectionConsumers(Map<String, List<FnDataReceiver<?>>> var1);

        public Builder incomingDataEndpoints(Map<Endpoints.ApiServiceDescriptor, List<DataEndpoint<?>>> var1);

        public Builder incomingTimerEndpoints(List<TimerEndpoint<?>> var1);

        public Builder startBundleFunctions(List<ThrowingRunnable> var1);

        public Builder finishBundleFunctions(List<ThrowingRunnable> var1);

        public Builder resetFunctions(List<ThrowingRunnable> var1);

        public Builder tearDownFunctions(List<ThrowingRunnable> var1);

        public Builder bundleProgressReporters(List<BundleProgressReporter> var1);

        public Builder splitListener(BundleSplitListener var1);

        public Builder bundleFinalizer(DoFn.BundleFinalizer var1);

        public Builder outboundAggregators(Map<Endpoints.ApiServiceDescriptor, BeamFnDataOutboundAggregator> var1);

        public Builder outgoingDataEndpoints(Map<Endpoints.ApiServiceDescriptor, List<DataEndpoint<?>>> var1);

        public Builder outgoingTimersEndpoints(List<TimerEndpoint<?>> var1);

        public Builder timerApiServiceDescriptor(Endpoints.ApiServiceDescriptor var1);

        public PTransformRunnerFactoryTestContext build();
    }
}

