/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import org.apache.beam.fn.harness.ToStringFnRunner;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.KV;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ToStringFnRunnerTest {
    @Test
    public void testPrimitiveToString() throws Exception {
        String pTransformId = "pTransformId";
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createDockerEnvironment((String)"java"));
        RunnerApi.PTransform pTransform = RunnerApi.PTransform.newBuilder().build();
        ThrowingFunction toStringFunction = ToStringFnRunner.createToStringFunctionForPTransform((String)pTransformId, (RunnerApi.PTransform)pTransform);
        KV input = KV.of((Object)"key", (Object)12345);
        Assert.assertEquals(KV.of((Object)"key", (Object)"12345"), toStringFunction.apply((Object)input));
    }

    @Test
    public void testToStringOverride() throws Exception {
        String pTransformId = "pTransformId";
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createDockerEnvironment((String)"java"));
        RunnerApi.PTransform pTransform = RunnerApi.PTransform.newBuilder().build();
        ThrowingFunction toStringFunction = ToStringFnRunner.createToStringFunctionForPTransform((String)pTransformId, (RunnerApi.PTransform)pTransform);
        class ClassWithToStringOverride {
            ClassWithToStringOverride() {
            }

            public String toString() {
                return "Some string";
            }
        }
        KV input = KV.of((Object)"key", (Object)new ClassWithToStringOverride());
        Assert.assertEquals(KV.of((Object)"key", (Object)"Some string"), toStringFunction.apply((Object)input));
    }
}

