/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import org.apache.beam.fn.harness.WindowMappingFnRunner;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.values.KV;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WindowMappingFnRunnerTest {
    @Test
    public void testWindowMapping() throws Exception {
        String pTransformId = "pTransformId";
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createDockerEnvironment((String)"java"));
        RunnerApi.FunctionSpec functionSpec = RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:map_windows:v1").setPayload(ParDoTranslation.translateWindowMappingFn((WindowMappingFn)new GlobalWindows().getDefaultWindowMappingFn(), (SdkComponents)components).toByteString()).build();
        RunnerApi.PTransform pTransform = RunnerApi.PTransform.newBuilder().setSpec(functionSpec).build();
        ThrowingFunction mapFunction = WindowMappingFnRunner.createMapFunctionForPTransform((String)pTransformId, (RunnerApi.PTransform)pTransform);
        KV input = KV.of((Object)"abc", (Object)new IntervalWindow(Instant.now(), (ReadableDuration)Duration.standardMinutes((long)1L)));
        Assert.assertEquals(KV.of((Object)input.getKey(), (Object)GlobalWindow.INSTANCE), mapFunction.apply((Object)input));
    }
}

