/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.util.Collections;
import java.util.HashSet;
import org.apache.beam.fn.harness.WindowMergingFnRunner;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.construction.Environments;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WindowMergingFnRunnerTest {
    @Test
    public void testWindowMergingWithNonMergingWindowFn() throws Exception {
        ThrowingFunction mapFunction = WindowMergingFnRunner.createMapFunctionForPTransform((String)"ptransformId", (RunnerApi.PTransform)WindowMergingFnRunnerTest.createMergeTransformForWindowFn(new GlobalWindows()));
        KV input = KV.of((Object)"abc", (Object)ImmutableList.of((Object)new IntervalWindow(Instant.now(), (ReadableDuration)Duration.standardMinutes((long)1L))));
        Assert.assertEquals(KV.of((Object)input.getKey(), (Object)KV.of((Object)((Iterable)input.getValue()), Collections.emptyList())), mapFunction.apply((Object)input));
    }

    @Test
    public void testWindowMergingWithMergingWindowFn() throws Exception {
        ThrowingFunction mapFunction = WindowMergingFnRunner.createMapFunctionForPTransform((String)"ptransformId", (RunnerApi.PTransform)WindowMergingFnRunnerTest.createMergeTransformForWindowFn(Sessions.withGapDuration((Duration)Duration.millis((long)5L))));
        Object[] expectedToBeMerged = new BoundedWindow[]{new IntervalWindow(new Instant(9L), new Instant(11L)), new IntervalWindow(new Instant(10L), new Instant(10L)), new IntervalWindow(new Instant(7L), new Instant(10L))};
        HashSet expectedToBeUnmerged = Sets.newHashSet((Object[])new BoundedWindow[]{new IntervalWindow(new Instant(1L), new Instant(1L)), new IntervalWindow(new Instant(20L), new Instant(20L))});
        KV input = KV.of((Object)"abc", (Object)ImmutableList.builder().add(expectedToBeMerged).addAll((Iterable)expectedToBeUnmerged).build());
        KV output = (KV)mapFunction.apply((Object)input);
        Assert.assertEquals(input.getKey(), output.getKey());
        Assert.assertEquals(expectedToBeUnmerged, ((KV)output.getValue()).getKey());
        KV mergedOutput = (KV)Iterables.getOnlyElement((Iterable)((Iterable)((KV)output.getValue()).getValue()));
        Assert.assertEquals(new IntervalWindow(new Instant(7L), new Instant(11L)), mergedOutput.getKey());
        MatcherAssert.assertThat((Iterable)mergedOutput.getValue(), Matchers.containsInAnyOrder(expectedToBeMerged));
        Object[] expectedToBeMergedGroup2 = new BoundedWindow[]{new IntervalWindow(new Instant(15L), new Instant(17L)), new IntervalWindow(new Instant(16L), new Instant(18L))};
        input = KV.of((Object)"abc", (Object)ImmutableList.builder().add(expectedToBeMergedGroup2).addAll((Iterable)expectedToBeUnmerged).build());
        output = (KV)mapFunction.apply((Object)input);
        Assert.assertEquals(input.getKey(), output.getKey());
        Assert.assertEquals(expectedToBeUnmerged, ((KV)output.getValue()).getKey());
        mergedOutput = (KV)Iterables.getOnlyElement((Iterable)((Iterable)((KV)output.getValue()).getValue()));
        Assert.assertEquals(new IntervalWindow(new Instant(15L), new Instant(18L)), mergedOutput.getKey());
        MatcherAssert.assertThat((Iterable)mergedOutput.getValue(), Matchers.containsInAnyOrder(expectedToBeMergedGroup2));
    }

    private static <W extends BoundedWindow> RunnerApi.PTransform createMergeTransformForWindowFn(WindowFn<?, W> windowFn) throws Exception {
        SdkComponents components = SdkComponents.create();
        components.registerEnvironment(Environments.createDockerEnvironment((String)"test"));
        RunnerApi.FunctionSpec functionSpec = RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:merge_windows:v1").setPayload(WindowingStrategyTranslation.toProto(windowFn, (SdkComponents)components).toByteString()).build();
        return RunnerApi.PTransform.newBuilder().setSpec(functionSpec).build();
    }
}

