/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.control;

import java.util.Collections;
import org.apache.beam.fn.harness.control.BundleSplitListener;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BundleSplitListenerTest {
    private static final BeamFnApi.BundleApplication TEST_PRIMARY_1 = BeamFnApi.BundleApplication.newBuilder().setInputId("primary1").build();
    private static final BeamFnApi.BundleApplication TEST_PRIMARY_2 = BeamFnApi.BundleApplication.newBuilder().setInputId("primary2").build();
    private static final BeamFnApi.DelayedBundleApplication TEST_RESIDUAL_1 = BeamFnApi.DelayedBundleApplication.newBuilder().setApplication(BeamFnApi.BundleApplication.newBuilder().setInputId("residual1").build()).build();
    private static final BeamFnApi.DelayedBundleApplication TEST_RESIDUAL_2 = BeamFnApi.DelayedBundleApplication.newBuilder().setApplication(BeamFnApi.BundleApplication.newBuilder().setInputId("residual2").build()).build();

    @Test
    public void testInMemory() {
        BundleSplitListener.InMemory splitListener = BundleSplitListener.InMemory.create();
        splitListener.split(Collections.singletonList(TEST_PRIMARY_1), Collections.singletonList(TEST_RESIDUAL_1));
        splitListener.split(Collections.singletonList(TEST_PRIMARY_2), Collections.singletonList(TEST_RESIDUAL_2));
        MatcherAssert.assertThat(splitListener.getPrimaryRoots(), Matchers.contains(TEST_PRIMARY_1, TEST_PRIMARY_2));
        MatcherAssert.assertThat(splitListener.getResidualRoots(), Matchers.contains(TEST_RESIDUAL_1, TEST_RESIDUAL_2));
        splitListener.clear();
        MatcherAssert.assertThat(splitListener.getPrimaryRoots(), Matchers.empty());
        MatcherAssert.assertThat(splitListener.getResidualRoots(), Matchers.empty());
    }
}

