/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.control;

import java.util.HashMap;
import org.apache.beam.fn.harness.control.HarnessMonitoringInfosInstructionHandler;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.core.metrics.LabeledMetrics;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.junit.Assert;
import org.junit.Test;

public class HarnessMonitoringInfosInstructionHandlerTest {
    @Test
    public void testReturnsProcessWideMonitoringInfos() {
        MetricsEnvironment.setProcessWideContainer((MetricsContainer)MetricsContainerImpl.createProcessWideContainer());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("SERVICE", "service");
        labels.put("METHOD", "method");
        labels.put("RESOURCE", "resource");
        labels.put("PTRANSFORM", "transform");
        labels.put("STATUS", "ok");
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, labels);
        Counter counter = LabeledMetrics.counter(name, true);
        counter.inc(7L);
        ShortIdMap metricsShortIds = new ShortIdMap();
        HarnessMonitoringInfosInstructionHandler testObject = new HarnessMonitoringInfosInstructionHandler(metricsShortIds);
        BeamFnApi.InstructionRequest.Builder builder = BeamFnApi.InstructionRequest.newBuilder();
        BeamFnApi.InstructionResponse.Builder responseBuilder = testObject.harnessMonitoringInfos(builder.build());
        BeamFnApi.InstructionResponse response = responseBuilder.build();
        Assert.assertEquals(1L, response.getHarnessMonitoringInfos().getMonitoringDataMap().size());
        Assert.assertTrue(!((ByteString)response.getHarnessMonitoringInfos().getMonitoringDataMap().get("metric0")).isEmpty());
    }
}

