/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.debug;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.beam.fn.harness.debug.DataSampler;
import org.apache.beam.fn.harness.debug.ElementSample;
import org.apache.beam.fn.harness.debug.OutputSampler;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DataSamplerTest {
    byte[] encodeInt(Integer i) throws IOException {
        VarIntCoder coder = VarIntCoder.of();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        coder.encode((Object)i, (OutputStream)stream, Coder.Context.NESTED);
        return stream.toByteArray();
    }

    byte[] encodeString(String s) throws IOException {
        StringUtf8Coder coder = StringUtf8Coder.of();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        coder.encode(s, (OutputStream)stream, Coder.Context.NESTED);
        return stream.toByteArray();
    }

    byte[] encodeByteArray(byte[] b) throws IOException {
        ByteArrayCoder coder = ByteArrayCoder.of();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        coder.encode(b, (OutputStream)stream, Coder.Context.NESTED);
        return stream.toByteArray();
    }

    <T> WindowedValue<T> globalWindowedValue(T el) {
        return WindowedValue.valueInGlobalWindow(el);
    }

    BeamFnApi.InstructionResponse getAllSamples(DataSampler dataSampler) {
        BeamFnApi.InstructionRequest request = BeamFnApi.InstructionRequest.newBuilder().setSampleData(BeamFnApi.SampleDataRequest.newBuilder().build()).build();
        return dataSampler.handleDataSampleRequest(request).build();
    }

    BeamFnApi.InstructionResponse getSamplesForPCollection(DataSampler dataSampler, String pcollection) {
        BeamFnApi.InstructionRequest request = BeamFnApi.InstructionRequest.newBuilder().setSampleData(BeamFnApi.SampleDataRequest.newBuilder().addPcollectionIds(pcollection).build()).build();
        return dataSampler.handleDataSampleRequest(request).build();
    }

    BeamFnApi.InstructionResponse getSamplesForPCollections(DataSampler dataSampler, Iterable<String> pcollections) {
        BeamFnApi.InstructionRequest request = BeamFnApi.InstructionRequest.newBuilder().setSampleData(BeamFnApi.SampleDataRequest.newBuilder().addAllPcollectionIds(pcollections).build()).build();
        return dataSampler.handleDataSampleRequest(request).build();
    }

    void assertHasSamples(BeamFnApi.InstructionResponse response, String pcollection, Iterable<byte[]> elements) {
        Map elementSamplesMap = response.getSampleData().getElementSamplesMap();
        Assert.assertFalse(elementSamplesMap.isEmpty());
        BeamFnApi.SampleDataResponse.ElementList elementList = (BeamFnApi.SampleDataResponse.ElementList)elementSamplesMap.get(pcollection);
        Assert.assertNotNull(elementList);
        ArrayList<BeamFnApi.SampledElement> expectedSamples = new ArrayList<BeamFnApi.SampledElement>();
        for (byte[] el : elements) {
            expectedSamples.add(BeamFnApi.SampledElement.newBuilder().setElement(ByteString.copyFrom((byte[])el)).build());
        }
        Assert.assertTrue(elementList.getElementsList().containsAll(expectedSamples));
    }

    void assertHasSamples(BeamFnApi.InstructionResponse response, String pcollection, List<BeamFnApi.SampledElement> elements) {
        Map elementSamplesMap = response.getSampleData().getElementSamplesMap();
        Assert.assertFalse(elementSamplesMap.isEmpty());
        BeamFnApi.SampleDataResponse.ElementList elementList = (BeamFnApi.SampleDataResponse.ElementList)elementSamplesMap.get(pcollection);
        Assert.assertNotNull(elementList);
        Assert.assertTrue(elementList.getElementsList().containsAll(elements));
    }

    @Test
    public void testSingleOutput() throws Exception {
        DataSampler sampler = new DataSampler();
        VarIntCoder coder = VarIntCoder.of();
        sampler.sampleOutput("pcollection-id", (Coder)coder).sample(this.globalWindowedValue(1));
        BeamFnApi.InstructionResponse samples = this.getAllSamples(sampler);
        this.assertHasSamples(samples, "pcollection-id", Collections.singleton(this.encodeInt(1)));
    }

    @Test
    public void testNestedContext() throws Exception {
        DataSampler sampler = new DataSampler();
        String rawString = "hello";
        byte[] byteArray = rawString.getBytes(StandardCharsets.US_ASCII);
        ByteArrayCoder coder = ByteArrayCoder.of();
        sampler.sampleOutput("pcollection-id", (Coder)coder).sample(this.globalWindowedValue(byteArray));
        BeamFnApi.InstructionResponse samples = this.getAllSamples(sampler);
        this.assertHasSamples(samples, "pcollection-id", Collections.singleton(this.encodeByteArray(byteArray)));
    }

    @Test
    public void testMultipleOutputs() throws Exception {
        DataSampler sampler = new DataSampler();
        VarIntCoder coder = VarIntCoder.of();
        sampler.sampleOutput("pcollection-id-1", (Coder)coder).sample(this.globalWindowedValue(1));
        sampler.sampleOutput("pcollection-id-2", (Coder)coder).sample(this.globalWindowedValue(2));
        BeamFnApi.InstructionResponse samples = this.getAllSamples(sampler);
        this.assertHasSamples(samples, "pcollection-id-1", Collections.singleton(this.encodeInt(1)));
        this.assertHasSamples(samples, "pcollection-id-2", Collections.singleton(this.encodeInt(2)));
    }

    @Test
    public void testMultipleSamePCollections() throws Exception {
        DataSampler sampler = new DataSampler();
        VarIntCoder coder = VarIntCoder.of();
        sampler.sampleOutput("pcollection-id", (Coder)coder).sample(this.globalWindowedValue(1));
        sampler.sampleOutput("pcollection-id", (Coder)coder).sample(this.globalWindowedValue(2));
        BeamFnApi.InstructionResponse samples = this.getAllSamples(sampler);
        this.assertHasSamples(samples, "pcollection-id", (Iterable<byte[]>)ImmutableList.of((Object)this.encodeInt(1), (Object)this.encodeInt(2)));
    }

    void generateStringSamples(DataSampler sampler) {
        StringUtf8Coder coder = StringUtf8Coder.of();
        sampler.sampleOutput("a", (Coder)coder).sample(this.globalWindowedValue("a1"));
        sampler.sampleOutput("a", (Coder)coder).sample(this.globalWindowedValue("a2"));
        sampler.sampleOutput("b", (Coder)coder).sample(this.globalWindowedValue("b1"));
        sampler.sampleOutput("b", (Coder)coder).sample(this.globalWindowedValue("b2"));
        sampler.sampleOutput("c", (Coder)coder).sample(this.globalWindowedValue("c1"));
        sampler.sampleOutput("c", (Coder)coder).sample(this.globalWindowedValue("c2"));
    }

    @Test
    public void testFiltersSinglePCollectionId() throws Exception {
        DataSampler sampler = new DataSampler(10, 10, Boolean.valueOf(false));
        this.generateStringSamples(sampler);
        BeamFnApi.InstructionResponse samples = this.getSamplesForPCollection(sampler, "a");
        this.assertHasSamples(samples, "a", (Iterable<byte[]>)ImmutableList.of((Object)this.encodeString("a1"), (Object)this.encodeString("a2")));
    }

    @Test
    public void testFiltersMultiplePCollectionIds() throws Exception {
        ImmutableList pcollectionIds = ImmutableList.of((Object)"a", (Object)"c");
        DataSampler sampler = new DataSampler(10, 10, Boolean.valueOf(false));
        this.generateStringSamples(sampler);
        BeamFnApi.InstructionResponse samples = this.getSamplesForPCollections(sampler, (Iterable<String>)pcollectionIds);
        MatcherAssert.assertThat(samples.getSampleData().getElementSamplesMap().size(), Matchers.equalTo(2));
        this.assertHasSamples(samples, "a", (Iterable<byte[]>)ImmutableList.of((Object)this.encodeString("a1"), (Object)this.encodeString("a2")));
        this.assertHasSamples(samples, "c", (Iterable<byte[]>)ImmutableList.of((Object)this.encodeString("c1"), (Object)this.encodeString("c2")));
    }

    @Test
    public void testConcurrentNewSampler() throws Exception {
        DataSampler sampler = new DataSampler();
        VarIntCoder coder = VarIntCoder.of();
        Thread[] sampleThreads = new Thread[100];
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(sampleThreads.length);
        for (int i = 0; i < sampleThreads.length; ++i) {
            sampleThreads[i] = new Thread(() -> {
                try {
                    startSignal.await();
                }
                catch (InterruptedException e) {
                    return;
                }
                for (int j = 0; j < 100; ++j) {
                    sampler.sampleOutput("pcollection-" + j, (Coder)coder).sample(this.globalWindowedValue(0));
                }
                doneSignal.countDown();
            });
            sampleThreads[i].start();
        }
        startSignal.countDown();
        while (doneSignal.getCount() > 0L) {
            sampler.handleDataSampleRequest(BeamFnApi.InstructionRequest.newBuilder().setSampleData(BeamFnApi.SampleDataRequest.newBuilder()).build());
        }
        for (Thread sampleThread : sampleThreads) {
            sampleThread.join();
        }
    }

    @Test
    public void testEnableAlwaysOnExceptionSampling() throws Exception {
        ExperimentalOptions experimentalOptions = (ExperimentalOptions)PipelineOptionsFactory.as(ExperimentalOptions.class);
        experimentalOptions.setExperiments(Collections.singletonList("enable_always_on_exception_sampling"));
        DataSampler sampler = DataSampler.create((PipelineOptions)experimentalOptions);
        Assert.assertNotNull(sampler);
        VarIntCoder coder = VarIntCoder.of();
        OutputSampler outputSampler = sampler.sampleOutput("pcollection-id", (Coder)coder);
        ElementSample elementSample = outputSampler.sample(this.globalWindowedValue(1));
        outputSampler.exception(elementSample, (Exception)new RuntimeException(), "", "");
        outputSampler.sample(this.globalWindowedValue(2));
        BeamFnApi.InstructionResponse samples = this.getAllSamples(sampler);
        ImmutableList expectedSamples = ImmutableList.of((Object)BeamFnApi.SampledElement.newBuilder().setElement(ByteString.copyFrom((byte[])this.encodeInt(1))).setException(BeamFnApi.SampledElement.Exception.newBuilder().setError(new RuntimeException().toString())).build());
        this.assertHasSamples(samples, "pcollection-id", (List<BeamFnApi.SampledElement>)expectedSamples);
    }

    @Test
    public void testDisableAlwaysOnExceptionSampling() throws Exception {
        ExperimentalOptions experimentalOptions = (ExperimentalOptions)PipelineOptionsFactory.as(ExperimentalOptions.class);
        experimentalOptions.setExperiments((List)ImmutableList.of((Object)"enable_always_on_exception_sampling", (Object)"disable_always_on_exception_sampling"));
        DataSampler sampler = DataSampler.create((PipelineOptions)experimentalOptions);
        Assert.assertNull(sampler);
    }

    @Test
    public void testDisableAlwaysOnExceptionSamplingWithEnableDataSampling() throws Exception {
        ExperimentalOptions experimentalOptions = (ExperimentalOptions)PipelineOptionsFactory.as(ExperimentalOptions.class);
        experimentalOptions.setExperiments((List)ImmutableList.of((Object)"enable_data_sampling", (Object)"enable_always_on_exception_sampling", (Object)"disable_always_on_exception_sampling"));
        DataSampler sampler = DataSampler.create((PipelineOptions)experimentalOptions);
        Assert.assertNotNull(sampler);
        VarIntCoder coder = VarIntCoder.of();
        OutputSampler outputSampler = sampler.sampleOutput("pcollection-id", (Coder)coder);
        ElementSample elementSample = outputSampler.sample(this.globalWindowedValue(1));
        outputSampler.exception(elementSample, (Exception)new RuntimeException(), "", "");
        outputSampler.sample(this.globalWindowedValue(2));
        BeamFnApi.InstructionResponse samples = this.getAllSamples(sampler);
        ImmutableList expectedSamples = ImmutableList.of((Object)BeamFnApi.SampledElement.newBuilder().setElement(ByteString.copyFrom((byte[])this.encodeInt(1))).setException(BeamFnApi.SampledElement.Exception.newBuilder().setError(new RuntimeException().toString())).build());
        this.assertHasSamples(samples, "pcollection-id", (List<BeamFnApi.SampledElement>)expectedSamples);
    }
}

