/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.logging;

import org.apache.beam.fn.harness.logging.BeamFnLoggingMDC;
import org.apache.beam.fn.harness.logging.RestoreBeamFnLoggingMDC;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.model.Statement;

@RunWith(value=JUnit4.class)
public class RestoreBeamFnLoggingMDCTest {
    @Rule
    public TestRule restoreMDCAfterTest = new RestoreBeamFnLoggingMDC();

    @Test
    public void testOldValuesAreRestored() throws Throwable {
        RestoreBeamFnLoggingMDC restoreMDC = new RestoreBeamFnLoggingMDC();
        final boolean[] evaluateRan = new boolean[1];
        BeamFnLoggingMDC.setInstructionId((String)"oldInstruction");
        restoreMDC.apply(new Statement(){

            @Override
            public void evaluate() {
                evaluateRan[0] = true;
                Assert.assertNull("null Instruction", BeamFnLoggingMDC.getInstructionId());
                BeamFnLoggingMDC.setInstructionId((String)"newInstruction");
                Assert.assertEquals("newInstruction", BeamFnLoggingMDC.getInstructionId());
            }
        }, Description.EMPTY).evaluate();
        Assert.assertTrue(evaluateRan[0]);
        Assert.assertEquals("oldInstruction", BeamFnLoggingMDC.getInstructionId());
    }
}

