/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import java.util.Arrays;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.FakeBeamFnStateClient;
import org.apache.beam.fn.harness.state.IterableSideInput;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IterableSideInputTest {
    @Test
    public void testGet() throws Exception {
        FakeBeamFnStateClient fakeBeamFnStateClient = new FakeBeamFnStateClient(StringUtf8Coder.of(), ImmutableMap.of((Object)this.key(), Arrays.asList("A1", "A2", "A3", "A4", "A5", "A6")));
        IterableSideInput iterableSideInput = new IterableSideInput(Caches.noop(), (BeamFnStateClient)fakeBeamFnStateClient, "instructionId", this.key(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"A1", "A2", "A3", "A4", "A5", "A6"}, Iterables.toArray((Iterable)iterableSideInput.get(), String.class));
    }

    @Test
    public void testGetCached() throws Exception {
        FakeBeamFnStateClient fakeBeamFnStateClient = new FakeBeamFnStateClient(StringUtf8Coder.of(), ImmutableMap.of((Object)this.key(), Arrays.asList("A1", "A2", "A3", "A4", "A5", "A6")));
        Cache cache = Caches.eternal();
        IterableSideInput iterableSideInput = new IterableSideInput(cache, (BeamFnStateClient)fakeBeamFnStateClient, "instructionId", this.key(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"A1", "A2", "A3", "A4", "A5", "A6"}, Iterables.toArray((Iterable)iterableSideInput.get(), String.class));
        iterableSideInput = new IterableSideInput(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.key(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"A1", "A2", "A3", "A4", "A5", "A6"}, Iterables.toArray((Iterable)iterableSideInput.get(), String.class));
    }

    private BeamFnApi.StateKey key() throws IOException {
        return BeamFnApi.StateKey.newBuilder().setIterableSideInput(BeamFnApi.StateKey.IterableSideInput.newBuilder().setTransformId("ptransformId").setSideInputId("sideInputId").setWindow(ByteString.copyFromUtf8((String)"encodedWindow"))).build();
    }
}

