/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.beam.fn.harness.state.LazyCachingIteratorToIterable;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.sdk.fn.stream.PrefetchableIterators;
import org.apache.beam.sdk.fn.stream.PrefetchableIteratorsTest;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LazyCachingIteratorToIterableTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testEmptyIterator() {
        LazyCachingIteratorToIterable iterable = new LazyCachingIteratorToIterable(PrefetchableIterators.emptyIterator());
        Assert.assertArrayEquals(new Object[0], Iterables.toArray((Iterable)iterable, Object.class));
        Assert.assertArrayEquals(new Object[0], Iterables.toArray((Iterable)iterable, Object.class));
        this.thrown.expect(NoSuchElementException.class);
        iterable.iterator().next();
    }

    @Test
    public void testInterleavedIteration() {
        LazyCachingIteratorToIterable iterable = new LazyCachingIteratorToIterable(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B", "C"}));
        Iterator iterator1 = iterable.iterator();
        Assert.assertTrue(iterator1.hasNext());
        Assert.assertEquals("A", iterator1.next());
        Iterator iterator2 = iterable.iterator();
        Assert.assertTrue(iterator2.hasNext());
        Assert.assertEquals("A", iterator2.next());
        Assert.assertTrue(iterator2.hasNext());
        Assert.assertEquals("B", iterator2.next());
        Assert.assertTrue(iterator1.hasNext());
        Assert.assertEquals("B", iterator1.next());
        Assert.assertTrue(iterator1.hasNext());
        Assert.assertEquals("C", iterator1.next());
        Assert.assertFalse(iterator1.hasNext());
        Assert.assertTrue(iterator2.hasNext());
        Assert.assertEquals("C", iterator2.next());
        Assert.assertFalse(iterator2.hasNext());
        this.thrown.expect(NoSuchElementException.class);
        iterator1.next();
    }

    @Test
    public void testEqualsAndHashCode() {
        LazyCachingIteratorToIterable iterA = new LazyCachingIteratorToIterable(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B", "C"}));
        LazyCachingIteratorToIterable iterB = new LazyCachingIteratorToIterable(PrefetchableIterators.fromArray((Object[])new String[]{"A", "B", "C"}));
        LazyCachingIteratorToIterable iterC = new LazyCachingIteratorToIterable(PrefetchableIterators.fromArray((Object[])new String[0]));
        LazyCachingIteratorToIterable iterD = new LazyCachingIteratorToIterable(PrefetchableIterators.fromArray((Object[])new String[0]));
        Assert.assertEquals(iterA, iterB);
        Assert.assertEquals(iterC, iterD);
        Assert.assertNotEquals(iterA, iterC);
        Assert.assertEquals(iterA.hashCode(), iterB.hashCode());
        Assert.assertEquals(iterC.hashCode(), iterD.hashCode());
    }

    @Test
    public void testPrefetch() {
        PrefetchableIteratorsTest.ReadyAfterPrefetch underlying = new PrefetchableIteratorsTest.ReadyAfterPrefetch((Iterator)PrefetchableIterators.fromArray((Object[])new String[]{"A", "B", "C"}));
        LazyCachingIteratorToIterable iterable = new LazyCachingIteratorToIterable((PrefetchableIterator)underlying);
        PrefetchableIterator iterator1 = iterable.iterator();
        PrefetchableIterator iterator2 = iterable.iterator();
        Assert.assertFalse(underlying.isReady());
        Assert.assertFalse(iterator1.isReady());
        Assert.assertFalse(iterator2.isReady());
        iterator1.prefetch();
        Assert.assertEquals(1L, underlying.getNumPrefetchCalls());
        iterator2.prefetch();
        Assert.assertEquals(1L, underlying.getNumPrefetchCalls());
        iterator1.next();
        iterator1.next();
        iterator2.next();
        iterator2.prefetch();
        Assert.assertEquals(1L, underlying.getNumPrefetchCalls());
    }
}

