/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.FakeBeamFnStateClient;
import org.apache.beam.fn.harness.state.MultimapSideInput;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MultimapSideInputTest {
    private static final byte[] A = "A".getBytes(StandardCharsets.UTF_8);
    private static final byte[] B = "B".getBytes(StandardCharsets.UTF_8);
    private static final byte[] UNKNOWN = "UNKNOWN".getBytes(StandardCharsets.UTF_8);

    @Test
    public void testGetWithBulkRead() throws Exception {
        FakeBeamFnStateClient fakeBeamFnStateClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.keysValuesStateKey(), (Object)KV.of((Object)KvCoder.of((Coder)ByteArrayCoder.of(), (Coder)IterableCoder.of((Coder)StringUtf8Coder.of())), Arrays.asList(KV.of((Object)A, Arrays.asList("A1", "A2", "A3")), KV.of((Object)B, Arrays.asList("B1", "B2"))))));
        MultimapSideInput multimapSideInput = new MultimapSideInput(Caches.noop(), (BeamFnStateClient)fakeBeamFnStateClient, "instructionId", this.keysStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of(), true);
        Assert.assertArrayEquals(new String[]{"A1", "A2", "A3"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)A), String.class));
        Assert.assertArrayEquals(new String[]{"B1", "B2"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)B), String.class));
        Assert.assertArrayEquals(new String[0], Iterables.toArray((Iterable)multimapSideInput.get((Object)UNKNOWN), String.class));
    }

    @Test
    public void testGet() throws Exception {
        FakeBeamFnStateClient fakeBeamFnStateClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.keysStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Arrays.asList(A, B)), (Object)this.key(A), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("A1", "A2", "A3")), (Object)this.key(B), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("B1", "B2"))));
        MultimapSideInput multimapSideInput = new MultimapSideInput(Caches.noop(), (BeamFnStateClient)fakeBeamFnStateClient, "instructionId", this.keysStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of(), true);
        Assert.assertArrayEquals(new String[]{"A1", "A2", "A3"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)A), String.class));
        Assert.assertArrayEquals(new String[]{"B1", "B2"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)B), String.class));
        Assert.assertArrayEquals(new String[0], Iterables.toArray((Iterable)multimapSideInput.get((Object)UNKNOWN), String.class));
        Assert.assertArrayEquals((Object[])new byte[][]{A, B}, Iterables.toArray((Iterable)multimapSideInput.get(), byte[].class));
    }

    @Test
    public void testGetCached() throws Exception {
        FakeBeamFnStateClient fakeBeamFnStateClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.keysStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Arrays.asList(A, B)), (Object)this.key(A), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("A1", "A2", "A3")), (Object)this.key(B), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("B1", "B2"))));
        Cache cache = Caches.eternal();
        MultimapSideInput multimapSideInput = new MultimapSideInput(cache, (BeamFnStateClient)fakeBeamFnStateClient, "instructionId", this.keysStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of(), true);
        Assert.assertArrayEquals(new String[]{"A1", "A2", "A3"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)A), String.class));
        Assert.assertArrayEquals(new String[]{"B1", "B2"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)B), String.class));
        Assert.assertArrayEquals(new String[0], Iterables.toArray((Iterable)multimapSideInput.get((Object)UNKNOWN), String.class));
        Assert.assertArrayEquals((Object[])new byte[][]{A, B}, Iterables.toArray((Iterable)multimapSideInput.get(), byte[].class));
        multimapSideInput = new MultimapSideInput(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.keysStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of(), true);
        Assert.assertArrayEquals(new String[]{"A1", "A2", "A3"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)A), String.class));
        Assert.assertArrayEquals(new String[]{"B1", "B2"}, Iterables.toArray((Iterable)multimapSideInput.get((Object)B), String.class));
        Assert.assertArrayEquals(new String[0], Iterables.toArray((Iterable)multimapSideInput.get((Object)UNKNOWN), String.class));
        Assert.assertArrayEquals((Object[])new byte[][]{A, B}, Iterables.toArray((Iterable)multimapSideInput.get(), byte[].class));
    }

    private BeamFnApi.StateKey keysStateKey() throws IOException {
        return BeamFnApi.StateKey.newBuilder().setMultimapKeysSideInput(BeamFnApi.StateKey.MultimapKeysSideInput.newBuilder().setTransformId("ptransformId").setSideInputId("sideInputId").setWindow(ByteString.copyFromUtf8((String)"encodedWindow"))).build();
    }

    private BeamFnApi.StateKey keysValuesStateKey() throws IOException {
        return BeamFnApi.StateKey.newBuilder().setMultimapKeysValuesSideInput(BeamFnApi.StateKey.MultimapKeysValuesSideInput.newBuilder().setTransformId("ptransformId").setSideInputId("sideInputId").setWindow(ByteString.copyFromUtf8((String)"encodedWindow"))).build();
    }

    private BeamFnApi.StateKey key(byte[] key) throws IOException {
        ByteStringOutputStream out = new ByteStringOutputStream();
        ByteArrayCoder.of().encode(key, (OutputStream)out);
        return BeamFnApi.StateKey.newBuilder().setMultimapSideInput(BeamFnApi.StateKey.MultimapSideInput.newBuilder().setTransformId("ptransformId").setSideInputId("sideInputId").setWindow(ByteString.copyFromUtf8((String)"encodedWindow")).setKey(out.toByteString())).build();
    }
}

