/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.FakeBeamFnStateClient;
import org.apache.beam.fn.harness.state.MultimapUserState;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.fn.stream.PrefetchableIterable;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MultimapUserStateTest {
    private static final byte[] A0 = "A0".getBytes(StandardCharsets.UTF_8);
    private static final byte[] A1 = "A1".getBytes(StandardCharsets.UTF_8);
    private static final byte[] A2 = "A2".getBytes(StandardCharsets.UTF_8);
    private static final byte[] A3 = "A3".getBytes(StandardCharsets.UTF_8);
    private final String pTransformId = "pTransformId";
    private final String stateId = "stateId";
    private final String encodedKey = "encodedKey";
    private final String encodedWindow = "encodedWindow";

    @Test
    public void testNoPersistedValues() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(Collections.emptyMap());
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
    }

    @Test
    public void testGet() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable initValues = userState.get((Object)A1);
        userState.put((Object)A1, (Object)"V3");
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)initValues, String.class));
        Assert.assertArrayEquals(new String[]{"V1", "V2", "V3"}, Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        Assert.assertArrayEquals(new String[0], Iterables.toArray((Iterable)userState.get((Object)A2), String.class));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.get((Object)A1));
    }

    @Test
    public void testClear() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable initValues = userState.get((Object)A1);
        userState.clear();
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)initValues, String.class));
        MatcherAssert.assertThat(userState.get((Object)A1), Is.is(Matchers.emptyIterable()));
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        userState.put((Object)A1, (Object)"V1");
        userState.clear();
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)initValues, String.class));
        MatcherAssert.assertThat(userState.get((Object)A1), Is.is(Matchers.emptyIterable()));
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.clear());
    }

    @Test
    public void testKeys() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.put((Object)A2, (Object)"V1");
        PrefetchableIterable initKeys = userState.keys();
        userState.put((Object)A3, (Object)"V1");
        userState.put((Object)A1, (Object)"V3");
        Assert.assertArrayEquals((Object[])new byte[][]{A1, A2}, Iterables.toArray((Iterable)initKeys, byte[].class));
        Assert.assertArrayEquals((Object[])new byte[][]{A1, A2, A3}, Iterables.toArray((Iterable)userState.keys(), byte[].class));
        userState.clear();
        Assert.assertArrayEquals((Object[])new byte[][]{A1, A2}, Iterables.toArray((Iterable)initKeys, byte[].class));
        Assert.assertArrayEquals((Object[])new byte[0][], Iterables.toArray((Iterable)userState.keys(), byte[].class));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.keys());
    }

    @Test
    public void testPut() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable initValues = userState.get((Object)A1);
        userState.put((Object)A1, (Object)"V3");
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)initValues, String.class));
        Assert.assertArrayEquals(new String[]{"V1", "V2", "V3"}, Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.put((Object)A1, (Object)"V2"));
    }

    @Test
    public void testPutAfterRemove() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A0)), (Object)this.createMultimapValueStateKey(A0), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.remove((Object)A0);
        userState.put((Object)A0, (Object)"V2");
        Assert.assertArrayEquals(new String[]{"V2"}, Iterables.toArray((Iterable)userState.get((Object)A0), String.class));
        userState.asyncClose();
        Assert.assertEquals(this.encode("V2"), fakeClient.getData().get(this.createMultimapValueStateKey(A0)));
    }

    @Test
    public void testPutAfterClear() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A0)), (Object)this.createMultimapValueStateKey(A0), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.clear();
        userState.put((Object)A0, (Object)"V2");
        Assert.assertArrayEquals(new String[]{"V2"}, Iterables.toArray((Iterable)userState.get((Object)A0), String.class));
    }

    @Test
    public void testRemoveBeforeClear() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A0)), (Object)this.createMultimapValueStateKey(A0), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.remove((Object)A0);
        userState.clear();
        userState.asyncClose();
        MatcherAssert.assertThat(fakeClient.getCallCount(), Is.is(1));
    }

    @Test
    public void testPutBeforeClear() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(Collections.emptyMap());
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.put((Object)A0, (Object)"V0");
        userState.put((Object)A1, (Object)"V1");
        PrefetchableIterable values = userState.get((Object)A1);
        userState.clear();
        Assert.assertArrayEquals(new String[]{"V1"}, Iterables.toArray((Iterable)values, String.class));
        userState.asyncClose();
        MatcherAssert.assertThat(fakeClient.getCallCount(), Is.is(2));
    }

    @Test
    public void testPutBeforeRemove() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(Collections.emptyMap());
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.put((Object)A0, (Object)"V0");
        userState.put((Object)A1, (Object)"V1");
        PrefetchableIterable values = userState.get((Object)A1);
        userState.remove((Object)A0);
        userState.remove((Object)A1);
        Assert.assertArrayEquals(new String[]{"V1"}, Iterables.toArray((Iterable)values, String.class));
        userState.asyncClose();
        MatcherAssert.assertThat(fakeClient.getCallCount(), Is.is(3));
        Assert.assertNull(fakeClient.getData().get(this.createMultimapValueStateKey(A0)));
        Assert.assertNull(fakeClient.getData().get(this.createMultimapValueStateKey(A1)));
    }

    @Test
    public void testRemove() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable initValues = userState.get((Object)A1);
        userState.put((Object)A1, (Object)"V3");
        userState.remove((Object)A1);
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)initValues, String.class));
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.remove((Object)A1));
    }

    @Test
    public void testImmutableKeys() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable keys = userState.keys();
        Iterator keysIterator = keys.iterator();
        keysIterator.next();
        Assert.assertThrows(UnsupportedOperationException.class, () -> keysIterator.remove());
    }

    @Test
    public void testImmutableValues() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable values = userState.get((Object)A1);
        Assert.assertThrows(UnsupportedOperationException.class, () -> MultimapUserStateTest.lambda$testImmutableValues$6((Iterable)values));
    }

    @Test
    public void testClearAsyncClose() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.clear();
        userState.asyncClose();
        Map<BeamFnApi.StateKey, ByteString> data = fakeClient.getData();
        Assert.assertEquals(1L, data.size());
        Assert.assertNull(data.get(this.createMultimapKeyStateKey()));
    }

    @Test
    public void testNoopAsyncClose() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.keys());
        Assert.assertEquals(0L, fakeClient.getCallCount());
    }

    @Test
    public void testAsyncClose() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Arrays.asList(A0, A1)), (Object)this.createMultimapValueStateKey(A0), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1")), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.remove((Object)A0);
        userState.put((Object)A1, (Object)"V3");
        userState.put((Object)A2, (Object)"V1");
        userState.put((Object)A3, (Object)"V1");
        userState.remove((Object)A3);
        userState.asyncClose();
        Map<BeamFnApi.StateKey, ByteString> data = fakeClient.getData();
        Assert.assertNull(data.get(this.createMultimapValueStateKey(A0)));
        Assert.assertEquals(this.encode("V1", "V2", "V3"), data.get(this.createMultimapValueStateKey(A1)));
        Assert.assertEquals(this.encode("V1"), data.get(this.createMultimapValueStateKey(A2)));
    }

    @Test
    public void testNullKeysAndValues() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)NullableCoder.of((Coder)ByteArrayCoder.of()), (Coder)NullableCoder.of((Coder)StringUtf8Coder.of()));
        userState.put(null, null);
        userState.put(null, null);
        userState.put(null, (Object)"V1");
        Assert.assertArrayEquals(new String[]{null, null, "V1"}, Iterables.toArray((Iterable)userState.get(null), String.class));
    }

    @Test
    public void testNegativeCache() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(Collections.emptyMap());
        MultimapUserState userState = new MultimapUserState(Caches.eternal(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[0], Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        Assert.assertArrayEquals(new String[0], Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        MatcherAssert.assertThat(fakeClient.getCallCount(), Is.is(1));
    }

    @Test
    public void testGetValuesPrefetch() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.eternal(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable values = userState.get((Object)A1);
        Assert.assertEquals(0L, fakeClient.getCallCount());
        values.prefetch();
        Assert.assertEquals(1L, fakeClient.getCallCount());
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)values, String.class));
        Assert.assertEquals(1L, fakeClient.getCallCount());
    }

    @Test
    public void testGetKeysPrefetch() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.eternal(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        PrefetchableIterable keys = userState.keys();
        Assert.assertEquals(0L, fakeClient.getCallCount());
        keys.prefetch();
        Assert.assertEquals(1L, fakeClient.getCallCount());
        Assert.assertArrayEquals((Object[])new byte[][]{A1}, Iterables.toArray((Iterable)keys, byte[].class));
        Assert.assertEquals(1L, fakeClient.getCallCount());
    }

    @Test
    public void testPutKeysPrefetch() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.eternal(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.put((Object)A2, (Object)"V3");
        PrefetchableIterable keys = userState.keys();
        Assert.assertEquals(0L, fakeClient.getCallCount());
        keys.prefetch();
        Assert.assertEquals(1L, fakeClient.getCallCount());
        Assert.assertArrayEquals((Object[])new byte[][]{A1, A2}, Iterables.toArray((Iterable)keys, byte[].class));
        Assert.assertEquals(1L, fakeClient.getCallCount());
    }

    @Test
    public void testRemoveKeysPrefetch() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.remove((Object)A1);
        userState.put((Object)A1, (Object)"V3");
        PrefetchableIterable values = userState.get((Object)A1);
        Assert.assertEquals(0L, fakeClient.getCallCount());
        values.prefetch();
        Assert.assertEquals(0L, fakeClient.getCallCount());
        Assert.assertArrayEquals(new String[]{"V3"}, Iterables.toArray((Iterable)values, String.class));
        Assert.assertEquals(0L, fakeClient.getCallCount());
    }

    @Test
    public void testClearPrefetch() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.clear();
        userState.put((Object)A2, (Object)"V3");
        PrefetchableIterable keys = userState.keys();
        Assert.assertEquals(0L, fakeClient.getCallCount());
        keys.prefetch();
        Assert.assertEquals(0L, fakeClient.getCallCount());
        Assert.assertArrayEquals((Object[])new byte[][]{A2}, Iterables.toArray((Iterable)keys, byte[].class));
        Assert.assertEquals(0L, fakeClient.getCallCount());
    }

    @Test
    public void testAppendValuesPrefetch() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        MultimapUserState userState = new MultimapUserState(Caches.eternal(), (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.put((Object)A1, (Object)"V3");
        PrefetchableIterable values = userState.get((Object)A1);
        Assert.assertEquals(0L, fakeClient.getCallCount());
        values.prefetch();
        Assert.assertEquals(1L, fakeClient.getCallCount());
        Assert.assertArrayEquals(new String[]{"V1", "V2", "V3"}, Iterables.toArray((Iterable)values, String.class));
        Assert.assertEquals(1L, fakeClient.getCallCount());
    }

    @Test
    public void testNoPersistedValuesCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(Collections.emptyMap());
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        MatcherAssert.assertThat(userState.get((Object)A1), Is.is(Matchers.emptyIterable()));
        userState = new MultimapUserState(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        MatcherAssert.assertThat(userState.get((Object)A1), Is.is(Matchers.emptyIterable()));
    }

    @Test
    public void testGetCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        userState.asyncClose();
        userState = new MultimapUserState(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        userState.asyncClose();
    }

    @Test
    public void testClearCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.clear();
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
        userState = new MultimapUserState(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
    }

    @Test
    public void testKeysCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.put((Object)A2, (Object)"V1");
        userState.put((Object)A3, (Object)"V1");
        Assert.assertArrayEquals((Object[])new byte[][]{A1, A2, A3}, Iterables.toArray((Iterable)userState.keys(), byte[].class));
        userState.asyncClose();
        userState = new MultimapUserState(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals((Object[])new byte[][]{A1, A2, A3}, Iterables.toArray((Iterable)userState.keys(), byte[].class));
        userState.asyncClose();
    }

    @Test
    public void testPutCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.put((Object)A1, (Object)"V3");
        userState.put((Object)A2, (Object)"V1");
        Assert.assertArrayEquals(new String[]{"V1", "V2", "V3"}, Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        userState.asyncClose();
        int callCount = fakeClient.getCallCount();
        MultimapUserState userState2 = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"V1", "V2", "V3"}, Iterables.toArray((Iterable)userState2.get((Object)A1), String.class));
        Assert.assertEquals(callCount, fakeClient.getCallCount());
        Assert.assertArrayEquals(new String[]{"V1"}, Iterables.toArray((Iterable)userState2.get((Object)A2), String.class));
        Assert.assertEquals(callCount + 1, fakeClient.getCallCount());
        userState2.asyncClose();
    }

    @Test
    public void testPutAfterRemoveCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A0)), (Object)this.createMultimapValueStateKey(A0), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1"))));
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.remove((Object)A0);
        userState.put((Object)A0, (Object)"V2");
        userState.asyncClose();
        userState = new MultimapUserState(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"V2"}, Iterables.toArray((Iterable)userState.get((Object)A0), String.class));
        userState.asyncClose();
    }

    @Test
    public void testPutAfterClearCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A0)), (Object)this.createMultimapValueStateKey(A0), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1"))));
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        userState.clear();
        userState.put((Object)A0, (Object)"V2");
        userState.asyncClose();
        userState = new MultimapUserState(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"V2"}, Iterables.toArray((Iterable)userState.get((Object)A0), String.class));
        Assert.assertArrayEquals((Object[])new byte[][]{A0}, Iterables.toArray((Iterable)userState.keys(), byte[].class));
        userState.asyncClose();
    }

    @Test
    public void testRemoveCached() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient((Map<BeamFnApi.StateKey, KV<Coder<?>, List<?>>>)ImmutableMap.of((Object)this.createMultimapKeyStateKey(), (Object)KV.of((Object)ByteArrayCoder.of(), Collections.singletonList(A1)), (Object)this.createMultimapValueStateKey(A1), (Object)KV.of((Object)StringUtf8Coder.of(), Arrays.asList("V1", "V2"))));
        Cache cache = Caches.eternal();
        MultimapUserState userState = new MultimapUserState(cache, (BeamFnStateClient)fakeClient, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(new String[]{"V1", "V2"}, Iterables.toArray((Iterable)userState.get((Object)A1), String.class));
        userState.remove((Object)A1);
        userState.remove((Object)A2);
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
        userState = new MultimapUserState(cache, requestBuilder -> {
            throw new IllegalStateException("Unexpected call for test.");
        }, "instructionId", this.createMultimapKeyStateKey(), (Coder)ByteArrayCoder.of(), (Coder)StringUtf8Coder.of());
        MatcherAssert.assertThat(userState.get((Object)A1), Is.is(Matchers.emptyIterable()));
        MatcherAssert.assertThat(userState.get((Object)A2), Is.is(Matchers.emptyIterable()));
        MatcherAssert.assertThat(userState.keys(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
    }

    private BeamFnApi.StateKey createMultimapKeyStateKey() throws IOException {
        return BeamFnApi.StateKey.newBuilder().setMultimapKeysUserState(BeamFnApi.StateKey.MultimapKeysUserState.newBuilder().setWindow(this.encode("encodedWindow")).setKey(this.encode("encodedKey")).setTransformId("pTransformId").setUserStateId("stateId")).build();
    }

    private BeamFnApi.StateKey createMultimapValueStateKey(byte[] key) throws IOException {
        return BeamFnApi.StateKey.newBuilder().setMultimapUserState(BeamFnApi.StateKey.MultimapUserState.newBuilder().setTransformId("pTransformId").setUserStateId("stateId").setWindow(this.encode("encodedWindow")).setKey(this.encode("encodedKey")).setMapKey(this.encode(new byte[][]{key}))).build();
    }

    private ByteString encode(String ... values) throws IOException {
        ByteStringOutputStream out = new ByteStringOutputStream();
        for (String value : values) {
            StringUtf8Coder.of().encode(value, (OutputStream)out);
        }
        return out.toByteString();
    }

    private ByteString encode(byte[] ... values) throws IOException {
        ByteStringOutputStream out = new ByteStringOutputStream();
        for (byte[] value : values) {
            ByteArrayCoder.of().encode(value, (OutputStream)out);
        }
        return out.toByteString();
    }

    private static /* synthetic */ void lambda$testImmutableValues$6(Iterable values) throws Throwable {
        Iterables.removeAll((Iterable)values, Arrays.asList("V1"));
    }
}

