/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.beam.fn.harness.Caches;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.FakeBeamFnStateClient;
import org.apache.beam.fn.harness.state.OrderedListUserState;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OrderedListUserStateTest {
    private static final TimestampedValue<String> A1 = TimestampedValue.of((Object)"A1", (Instant)Instant.ofEpochMilli((long)1L));
    private static final TimestampedValue<String> B1 = TimestampedValue.of((Object)"B1", (Instant)Instant.ofEpochMilli((long)1L));
    private static final TimestampedValue<String> C1 = TimestampedValue.of((Object)"C1", (Instant)Instant.ofEpochMilli((long)1L));
    private static final TimestampedValue<String> A2 = TimestampedValue.of((Object)"A2", (Instant)Instant.ofEpochMilli((long)2L));
    private static final TimestampedValue<String> B2 = TimestampedValue.of((Object)"B2", (Instant)Instant.ofEpochMilli((long)2L));
    private static final TimestampedValue<String> A3 = TimestampedValue.of((Object)"A3", (Instant)Instant.ofEpochMilli((long)3L));
    private static final TimestampedValue<String> A4 = TimestampedValue.of((Object)"A4", (Instant)Instant.ofEpochMilli((long)4L));
    private final String pTransformId = "pTransformId";
    private final String stateId = "stateId";
    private final String encodedWindow = "encodedWindow";
    private final Coder<TimestampedValue<String>> timestampedValueCoder = OrderedListUserState.TimestampedValueCoder.of((Coder)StringUtf8Coder.of());

    @Test
    public void testNoPersistedValues() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(Collections.emptyMap());
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        MatcherAssert.assertThat(userState.read(), Is.is(Matchers.emptyIterable()));
    }

    @Test
    public void testRead() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Arrays.asList(A1, B1)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(Arrays.asList(A1, B1).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.read());
    }

    @Test
    public void testReadRange() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Arrays.asList(A1, B1), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4), (Object)this.createOrderedListStateKey("A", 2L), Collections.singletonList(A2)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Iterable stateBeforeB2 = userState.readRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)4L));
        Assert.assertArrayEquals(Collections.singletonList(A2).toArray(), Iterables.toArray((Iterable)stateBeforeB2, TimestampedValue.class));
        userState.add(B2);
        Assert.assertArrayEquals(Collections.singletonList(A2).toArray(), Iterables.toArray((Iterable)stateBeforeB2, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A2, B2).toArray(), Iterables.toArray((Iterable)userState.readRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)4L)), TimestampedValue.class));
        userState.add(A3);
        Assert.assertArrayEquals(Collections.singletonList(A2).toArray(), Iterables.toArray((Iterable)stateBeforeB2, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A2, B2, A3).toArray(), Iterables.toArray((Iterable)userState.readRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)4L)), TimestampedValue.class));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.readRange(Instant.ofEpochMilli((long)1L), Instant.ofEpochMilli((long)2L)));
    }

    @Test
    public void testAdd() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4), (Object)this.createOrderedListStateKey("A", 2L), Arrays.asList(A2, B2)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.add(B1);
        Assert.assertArrayEquals(Arrays.asList(A1, B1, A2, B2, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(A3);
        Assert.assertArrayEquals(Arrays.asList(A1, B1, A2, B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(B1);
        Assert.assertArrayEquals(Arrays.asList(A1, B1, B1, A2, B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.add(A1));
    }

    @Test
    public void testClearRange() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Arrays.asList(A1, B1), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4), (Object)this.createOrderedListStateKey("A", 2L), Arrays.asList(A2, B2), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Iterable initStateFrom2To3 = userState.readRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)4L));
        userState.clearRange(Instant.ofEpochMilli((long)-1L), Instant.ofEpochMilli((long)0L));
        Assert.assertArrayEquals(Arrays.asList(A2, B2, A3).toArray(), Iterables.toArray((Iterable)initStateFrom2To3, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A1, B1, A2, B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.clearRange(Instant.ofEpochMilli((long)5L), Instant.ofEpochMilli((long)10L));
        Assert.assertArrayEquals(Arrays.asList(A2, B2, A3).toArray(), Iterables.toArray((Iterable)initStateFrom2To3, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A1, B1, A2, B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.clearRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)4L));
        Assert.assertArrayEquals(Arrays.asList(A2, B2, A3).toArray(), Iterables.toArray((Iterable)initStateFrom2To3, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A1, B1, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.clearRange(Instant.ofEpochMilli((long)3L), Instant.ofEpochMilli((long)5L));
        Assert.assertArrayEquals(Arrays.asList(A2, B2, A3).toArray(), Iterables.toArray((Iterable)initStateFrom2To3, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A1, B1).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.clearRange(Instant.ofEpochMilli((long)-1L), Instant.ofEpochMilli((long)10L));
        Assert.assertArrayEquals(Arrays.asList(A2, B2, A3).toArray(), Iterables.toArray((Iterable)initStateFrom2To3, TimestampedValue.class));
        MatcherAssert.assertThat(userState.read(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.clearRange(Instant.ofEpochMilli((long)1L), Instant.ofEpochMilli((long)2L)));
    }

    @Test
    public void testClear() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Arrays.asList(A1, B1), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4), (Object)this.createOrderedListStateKey("A", 2L), Arrays.asList(A2, B2), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Iterable stateBeforeClear = userState.read();
        userState.clear();
        Assert.assertArrayEquals(Arrays.asList(A1, B1, A2, B2, A3, A4).toArray(), Iterables.toArray((Iterable)stateBeforeClear, TimestampedValue.class));
        MatcherAssert.assertThat(userState.read(), Is.is(Matchers.emptyIterable()));
        userState.asyncClose();
        Assert.assertThrows(IllegalStateException.class, () -> userState.clear());
    }

    @Test
    public void testAddAndClearRange() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.add(A2);
        Iterable stateBeforeFirstClearRange = userState.read();
        userState.clearRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)3L));
        Assert.assertArrayEquals(Arrays.asList(A1, A2, A3, A4).toArray(), Iterables.toArray((Iterable)stateBeforeFirstClearRange, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A1, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(B2);
        Assert.assertArrayEquals(Arrays.asList(A1, A2, A3, A4).toArray(), Iterables.toArray((Iterable)stateBeforeFirstClearRange, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(A1, B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(B1);
        userState.clearRange(Instant.ofEpochMilli((long)1L), Instant.ofEpochMilli((long)2L));
        Assert.assertArrayEquals(Arrays.asList(A1, A2, A3, A4).toArray(), Iterables.toArray((Iterable)stateBeforeFirstClearRange, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(B1);
        Assert.assertArrayEquals(Arrays.asList(A1, A2, A3, A4).toArray(), Iterables.toArray((Iterable)stateBeforeFirstClearRange, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(B1, B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(A3);
        userState.clearRange(Instant.ofEpochMilli((long)3L), Instant.ofEpochMilli((long)4L));
        Assert.assertArrayEquals(Arrays.asList(A1, A2, A3, A4).toArray(), Iterables.toArray((Iterable)stateBeforeFirstClearRange, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(B1, B2, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(A3);
        Assert.assertArrayEquals(Arrays.asList(A1, A2, A3, A4).toArray(), Iterables.toArray((Iterable)stateBeforeFirstClearRange, TimestampedValue.class));
        Assert.assertArrayEquals(Arrays.asList(B1, B2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
    }

    @Test
    public void testAddAndClearRangeAfterClear() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.clear();
        userState.clearRange(Instant.ofEpochMilli((long)0L), Instant.ofEpochMilli((long)5L));
        MatcherAssert.assertThat(userState.read(), Is.is(Matchers.emptyIterable()));
        userState.add(A1);
        Assert.assertArrayEquals(Collections.singletonList(A1).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.add(A2);
        userState.add(A3);
        Assert.assertArrayEquals(Arrays.asList(A1, A2, A3).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
        userState.clearRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)3L));
        Assert.assertArrayEquals(Arrays.asList(A1, A3).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
    }

    @Test
    public void testNoopAsyncCloseAndRead() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.asyncClose();
        userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(Arrays.asList(A1, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
    }

    @Test
    public void testAddAsyncCloseAndRead() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.add(B1);
        userState.add(A2);
        userState.asyncClose();
        userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(Arrays.asList(A1, B1, A2, A3, A4).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
    }

    @Test
    public void testClearRangeAsyncCloseAndRead() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 2L), Collections.singletonList(A2), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.clearRange(Instant.ofEpochMilli((long)1L), Instant.ofEpochMilli((long)3L));
        userState.clearRange(Instant.ofEpochMilli((long)4L), Instant.ofEpochMilli((long)5L));
        userState.asyncClose();
        userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(Collections.singletonList(A3).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
    }

    @Test
    public void testAddClearRangeAsyncCloseAndRead() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.add(B1);
        userState.add(A2);
        userState.add(A3);
        userState.clearRange(Instant.ofEpochMilli((long)1L), Instant.ofEpochMilli((long)3L));
        userState.clearRange(Instant.ofEpochMilli((long)4L), Instant.ofEpochMilli((long)5L));
        userState.asyncClose();
        userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Assert.assertArrayEquals(Collections.singletonList(A3).toArray(), Iterables.toArray((Iterable)userState.read(), TimestampedValue.class));
    }

    @Test
    public void testClearAsyncCloseAndRead() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Collections.singletonList(A1), (Object)this.createOrderedListStateKey("A", 2L), Collections.singletonList(A2), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        userState.clear();
        userState.asyncClose();
        userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        MatcherAssert.assertThat(userState.read(), Is.is(Matchers.emptyIterable()));
    }

    @Test
    public void testOperationsDuringNavigatingIterable() throws Exception {
        FakeBeamFnStateClient fakeClient = new FakeBeamFnStateClient(this.timestampedValueCoder, ImmutableMap.of((Object)this.createOrderedListStateKey("A", 1L), Arrays.asList(A1, B1), (Object)this.createOrderedListStateKey("A", 2L), Arrays.asList(A2, B2), (Object)this.createOrderedListStateKey("A", 3L), Collections.singletonList(A3), (Object)this.createOrderedListStateKey("A", 4L), Collections.singletonList(A4)));
        OrderedListUserState userState = new OrderedListUserState(Caches.noop(), (BeamFnStateClient)fakeClient, "instructionId", this.createOrderedListStateKey("A"), (Coder)StringUtf8Coder.of());
        Iterator iter = userState.read().iterator();
        Assert.assertEquals(iter.next(), A1);
        userState.add(C1);
        Assert.assertEquals(iter.next(), B1);
        Assert.assertEquals(iter.next(), A2);
        userState.clearRange(Instant.ofEpochMilli((long)2L), Instant.ofEpochMilli((long)4L));
        Assert.assertEquals(iter.next(), B2);
        Assert.assertEquals(iter.next(), A3);
        userState.clear();
        Assert.assertEquals(iter.next(), A4);
    }

    private ByteString encode(String ... values) throws IOException {
        ByteStringOutputStream out = new ByteStringOutputStream();
        for (String value : values) {
            StringUtf8Coder.of().encode(value, (OutputStream)out);
        }
        return out.toByteString();
    }

    private BeamFnApi.StateKey createOrderedListStateKey(String key) throws IOException {
        return BeamFnApi.StateKey.newBuilder().setOrderedListUserState(BeamFnApi.StateKey.OrderedListUserState.newBuilder().setWindow(this.encode("encodedWindow")).setTransformId("pTransformId").setUserStateId("stateId").setKey(this.encode(key))).build();
    }

    private BeamFnApi.StateKey createOrderedListStateKey(String key, long sortKey) throws IOException {
        return BeamFnApi.StateKey.newBuilder().setOrderedListUserState(BeamFnApi.StateKey.OrderedListUserState.newBuilder().setWindow(this.encode("encodedWindow")).setTransformId("pTransformId").setUserStateId("stateId").setKey(this.encode(key)).setRange(BeamFnApi.OrderedListRange.newBuilder().setStart(sortKey).setEnd(sortKey + 1L).build())).build();
    }
}

