/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.status;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.fn.harness.status.MemoryMonitor;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MemoryMonitorTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private FakeGCStatsProvider provider;
    private File localDumpFolder;
    private MemoryMonitor monitor;
    private Thread thread;

    @Before
    public void setup() throws IOException {
        this.provider = new FakeGCStatsProvider();
        this.localDumpFolder = this.tempFolder.newFolder();
        this.monitor = MemoryMonitor.forTest((MemoryMonitor.GCStatsProvider)this.provider, (long)10L, (int)0, (boolean)false, (double)50.0, null, (File)this.localDumpFolder);
        this.thread = new Thread((Runnable)this.monitor);
        this.thread.start();
    }

    @Test(timeout=1000L)
    public void detectGCThrashing() throws InterruptedException {
        this.monitor.waitForRunning();
        this.monitor.waitForResources("Test1");
        this.provider.inGCThrashingState.set(true);
        this.monitor.waitForThrashingState(true);
        Semaphore s = new Semaphore(0);
        new Thread(() -> {
            this.monitor.waitForResources("Test2");
            s.release();
        }).start();
        Assert.assertFalse(s.tryAcquire(100L, TimeUnit.MILLISECONDS));
        this.provider.inGCThrashingState.set(false);
        this.monitor.waitForThrashingState(false);
        Assert.assertTrue(s.tryAcquire(100L, TimeUnit.MILLISECONDS));
        this.monitor.waitForResources("Test3");
    }

    @Test
    public void heapDumpOnce() throws Exception {
        File folder = this.tempFolder.newFolder();
        File dump1 = MemoryMonitor.dumpHeap((File)folder);
        Assert.assertNotNull(dump1);
        Assert.assertTrue(dump1.exists());
        MatcherAssert.assertThat(dump1.getParentFile(), Matchers.equalTo(folder));
    }

    @Test
    public void heapDumpTwice() throws Exception {
        File folder = this.tempFolder.newFolder();
        File dump1 = MemoryMonitor.dumpHeap((File)folder);
        Assert.assertNotNull(dump1);
        Assert.assertTrue(dump1.exists());
        MatcherAssert.assertThat(dump1.getParentFile(), Matchers.equalTo(folder));
        File dump2 = MemoryMonitor.dumpHeap((File)folder);
        Assert.assertNotNull(dump2);
        Assert.assertTrue(dump2.exists());
        MatcherAssert.assertThat(dump2.getParentFile(), Matchers.equalTo(folder));
    }

    @Test
    public void uploadFile() throws Exception {
        File remoteFolder = this.tempFolder.newFolder();
        this.monitor = MemoryMonitor.forTest((MemoryMonitor.GCStatsProvider)this.provider, (long)10L, (int)0, (boolean)true, (double)50.0, (String)remoteFolder.getPath(), (File)this.localDumpFolder);
        this.monitor.dumpHeap();
        Assert.assertTrue(this.monitor.tryUploadHeapDumpIfItExists());
        File[] files = remoteFolder.listFiles();
        MatcherAssert.assertThat(files, Matchers.arrayWithSize(1));
        MatcherAssert.assertThat(files[0].getAbsolutePath(), Matchers.containsString("heap_dump"));
        MatcherAssert.assertThat(files[0].getAbsolutePath(), Matchers.containsString("hprof"));
    }

    @Test
    public void uploadFileDisabled() throws Exception {
        this.monitor = MemoryMonitor.forTest((MemoryMonitor.GCStatsProvider)this.provider, (long)10L, (int)0, (boolean)true, (double)50.0, null, (File)this.localDumpFolder);
        this.monitor.dumpHeap();
        Assert.assertFalse(this.monitor.tryUploadHeapDumpIfItExists());
    }

    @Test
    public void disableMemoryMonitor() throws Exception {
        MemoryMonitor disabledMonitor = MemoryMonitor.forTest((MemoryMonitor.GCStatsProvider)this.provider, (long)10L, (int)0, (boolean)true, (double)100.0, null, (File)this.localDumpFolder);
        Thread disabledMonitorThread = new Thread((Runnable)disabledMonitor);
        disabledMonitorThread.start();
        disabledMonitorThread.join(10000L);
        Assert.assertFalse(disabledMonitorThread.isAlive());
        Assert.assertTrue(this.thread.isAlive());
    }

    static class FakeGCStatsProvider
    implements MemoryMonitor.GCStatsProvider {
        AtomicBoolean inGCThrashingState = new AtomicBoolean(false);
        long lastCallTimestamp = System.currentTimeMillis();
        long lastGCResult = 0L;

        FakeGCStatsProvider() {
        }

        public long totalGCTimeMilliseconds() {
            if (this.inGCThrashingState.get()) {
                long now = System.currentTimeMillis();
                this.lastGCResult += now - this.lastCallTimestamp;
                this.lastCallTimestamp = now;
            }
            return this.lastGCResult;
        }
    }
}

