/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.stream;

import org.apache.beam.fn.harness.stream.HarnessStreamObserverFactories;
import org.apache.beam.sdk.fn.stream.BufferingStreamObserver;
import org.apache.beam.sdk.fn.stream.DirectStreamObserver;
import org.apache.beam.sdk.fn.stream.ForwardingClientResponseObserver;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.CallStreamObserver;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.stub.StreamObserver;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class HarnessStreamObserverFactoriesTest {
    @Mock
    private StreamObserver<Integer> mockRequestObserver;
    @Mock
    private CallStreamObserver<String> mockResponseObserver;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void testDefaultInstantiation() {
        StreamObserver observer = HarnessStreamObserverFactories.fromOptions((PipelineOptions)PipelineOptionsFactory.create()).outboundObserverFor(this::fakeFactory, this.mockRequestObserver);
        MatcherAssert.assertThat(observer, Matchers.instanceOf(DirectStreamObserver.class));
    }

    @Test
    public void testBufferedStreamInstantiation() {
        StreamObserver observer = HarnessStreamObserverFactories.fromOptions((PipelineOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--experiments=beam_fn_api_buffered_stream"}).create()).outboundObserverFor(this::fakeFactory, this.mockRequestObserver);
        MatcherAssert.assertThat(observer, Matchers.instanceOf(BufferingStreamObserver.class));
    }

    @Test
    public void testBufferedStreamWithLimitInstantiation() {
        StreamObserver observer = HarnessStreamObserverFactories.fromOptions((PipelineOptions)PipelineOptionsFactory.fromArgs((String[])new String[]{"--experiments=beam_fn_api_buffered_stream,beam_fn_api_buffered_stream_buffer_size=1"}).create()).outboundObserverFor(this::fakeFactory, this.mockRequestObserver);
        MatcherAssert.assertThat(observer, Matchers.instanceOf(BufferingStreamObserver.class));
        Assert.assertEquals(1L, ((BufferingStreamObserver)observer).getBufferSize());
    }

    private StreamObserver<String> fakeFactory(StreamObserver<Integer> observer) {
        MatcherAssert.assertThat(observer, Matchers.instanceOf(ForwardingClientResponseObserver.class));
        return this.mockResponseObserver;
    }
}

