/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.BoundedTrieResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Some access on purpose are left unsynchronized")
public class BoundedTrieData
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BOUND = 100;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> singleton;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized BoundedTrieNode root;
    private @UnknownKeyFor @NonNull @Initialized int bound;

    public BoundedTrieData() {
        this(null, null, 100);
    }

    public BoundedTrieData(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> singleton) {
        this(singleton, null, 100);
    }

    public BoundedTrieData(@UnknownKeyFor @NonNull @Initialized BoundedTrieNode root) {
        this(null, root, 100);
    }

    public BoundedTrieData(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> singleton, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized BoundedTrieNode root, @UnknownKeyFor @NonNull @Initialized int bound) {
        assert (singleton == null || root == null);
        this.singleton = singleton;
        this.root = root;
        this.bound = bound;
    }

    public synchronized // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.BoundedTrie toProto() {
        MetricsApi.BoundedTrie.Builder builder = MetricsApi.BoundedTrie.newBuilder();
        builder.setBound(this.bound);
        if (this.singleton != null) {
            builder.addAllSingleton(this.singleton);
        }
        if (this.root != null) {
            builder.setRoot(this.root.toProto());
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized BoundedTrieData fromProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized MetricsApi.BoundedTrie proto) {
        if (proto.hasRoot()) {
            return new BoundedTrieData(null, BoundedTrieNode.fromProto(proto.getRoot()), proto.getBound());
        }
        return new BoundedTrieData((List<String>)proto.getSingletonList(), null, proto.getBound());
    }

    @Nonnull
    private synchronized @UnknownKeyFor @NonNull @Initialized BoundedTrieNode asTrie() {
        if (this.root != null) {
            return this.root;
        }
        BoundedTrieNode trieNode = new BoundedTrieNode();
        if (this.singleton != null) {
            trieNode.add(this.singleton);
        }
        return trieNode;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized BoundedTrieData getCumulative() {
        ArrayList<String> singleton = this.singleton == null ? null : new ArrayList<String>(this.singleton);
        BoundedTrieNode root = this.root == null ? null : this.root.deepCopy();
        return new BoundedTrieData(singleton, root, this.bound);
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized BoundedTrieResult extractResult() {
        if (this.root == null) {
            if (this.singleton == null) {
                return BoundedTrieResult.empty();
            }
            ArrayList<String> list = new ArrayList<String>(this.singleton);
            list.add(String.valueOf(false));
            return BoundedTrieResult.create(Collections.singleton(list));
        }
        return BoundedTrieResult.create(new HashSet<List<String>>(this.root.flattened()));
    }

    public synchronized void add(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> segments) {
        ImmutableList segmentsParts = ImmutableList.copyOf(segments);
        if (segmentsParts.isEmpty()) {
            return;
        }
        if (this.singleton == null && this.root == null) {
            this.singleton = segmentsParts;
        } else if (this.singleton == null || !this.singleton.equals(segmentsParts)) {
            if (this.root == null) {
                this.root = this.asTrie();
                this.singleton = null;
            }
            this.root.add((List<String>)segmentsParts);
            if (this.root.getSize() > this.bound) {
                this.root.trim();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @UnknownKeyFor @NonNull @Initialized BoundedTrieData combine(@Nonnull @UnknownKeyFor @NonNull @Initialized BoundedTrieData other) {
        BoundedTrieData otherDeepCopy;
        BoundedTrieData boundedTrieData = other;
        synchronized (boundedTrieData) {
            if (other.root == null && other.singleton == null) {
                return this;
            }
            otherDeepCopy = other.getCumulative();
        }
        boundedTrieData = this;
        synchronized (boundedTrieData) {
            if (this.root == null && this.singleton == null) {
                return otherDeepCopy;
            }
            otherDeepCopy.root = otherDeepCopy.asTrie();
            otherDeepCopy.singleton = null;
            otherDeepCopy.root.merge(this.asTrie());
            otherDeepCopy.bound = Math.min(this.bound, otherDeepCopy.bound);
            while (otherDeepCopy.root.getSize() > otherDeepCopy.bound) {
                otherDeepCopy.root.trim();
            }
            return otherDeepCopy;
        }
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized int size() {
        if (this.singleton != null) {
            return 1;
        }
        if (this.root != null) {
            return this.root.getSize();
        }
        return 0;
    }

    public synchronized void clear() {
        this.root = null;
        this.singleton = null;
        this.bound = 100;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized boolean contains(@Nonnull @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> value) {
        if (this.singleton != null) {
            return value.equals(this.singleton);
        }
        if (this.root != null) {
            return this.root.contains(value);
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return !(this.root != null && !this.root.children.isEmpty() || this.singleton != null && !this.singleton.isEmpty());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public final @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BoundedTrieData that = (BoundedTrieData)other;
        return this.asTrie().equals(that.asTrie());
    }

    @Pure
    public final @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.asTrie().hashCode();
    }

    @SideEffectFree
    public final @UnknownKeyFor @NonNull @Initialized String toString() {
        return "BoundedTrieData(" + this.asTrie() + ")";
    }

    @VisibleForTesting
    static class BoundedTrieNode
    implements Serializable {
        public static final @UnknownKeyFor @NonNull @Initialized String TRUNCATED_TRUE = String.valueOf(true);
        public static final @UnknownKeyFor @NonNull @Initialized String TRUNCATED_FALSE = String.valueOf(false);
        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BoundedTrieNode> children;
        private @UnknownKeyFor @NonNull @Initialized boolean truncated;
        private @UnknownKeyFor @NonNull @Initialized int size;

        BoundedTrieNode() {
            this(new HashMap<String, BoundedTrieNode>(), false, 1);
        }

        BoundedTrieNode(@Nonnull @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BoundedTrieNode> children, @UnknownKeyFor @NonNull @Initialized boolean truncated, @UnknownKeyFor @NonNull @Initialized int size) {
            this.children = children;
            this.size = size;
            this.truncated = truncated;
        }

        @UnknownKeyFor @NonNull @Initialized BoundedTrieNode deepCopy() {
            BoundedTrieNode copyNode = new BoundedTrieNode();
            copyNode.truncated = this.truncated;
            copyNode.size = this.size;
            copyNode.children = new HashMap<String, BoundedTrieNode>();
            this.children.forEach((key, value) -> copyNode.children.put((String)key, value.deepCopy()));
            return copyNode;
        }

        @UnknownKeyFor @NonNull @Initialized int add(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> segments) {
            if (this.truncated || segments.isEmpty()) {
                return 0;
            }
            String head = segments.get(0);
            List<String> tail = segments.subList(1, segments.size());
            boolean wasEmpty = this.children.isEmpty();
            BoundedTrieNode currChild = this.children.get(head);
            int delta = 0;
            if (currChild == null) {
                currChild = new BoundedTrieNode();
                this.children.put(head, currChild);
                int n = delta = wasEmpty ? 0 : 1;
            }
            if (!tail.isEmpty()) {
                delta += currChild.add(tail);
            }
            this.size += delta;
            return delta;
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized int addAll(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> segmentsIter) {
            return segmentsIter.stream().mapToInt(this::add).sum();
        }

        @UnknownKeyFor @NonNull @Initialized int trim() {
            int delta;
            if (this.children.isEmpty()) {
                return 0;
            }
            BoundedTrieNode maxChild = Collections.max(this.children.values(), Comparator.comparingInt(BoundedTrieNode::getSize));
            if (maxChild.size == 1) {
                delta = 1 - this.size;
                this.truncated = true;
                this.children = new HashMap<String, BoundedTrieNode>();
            } else {
                delta = maxChild.trim();
            }
            this.size += delta;
            return delta;
        }

        @UnknownKeyFor @NonNull @Initialized int merge(@UnknownKeyFor @NonNull @Initialized BoundedTrieNode other) {
            if (this.truncated) {
                return 0;
            }
            if (other.truncated) {
                this.truncated = true;
                this.children = new HashMap<String, BoundedTrieNode>();
                int delta = 1 - this.size;
                this.size += delta;
                return delta;
            }
            if (other.children.isEmpty()) {
                return 0;
            }
            if (this.children.isEmpty()) {
                this.children.putAll(other.children);
                int delta = other.size - this.size;
                this.size += delta;
                return delta;
            }
            int delta = 0;
            for (Map.Entry<String, BoundedTrieNode> entry : other.children.entrySet()) {
                String prefix = entry.getKey();
                BoundedTrieNode otherChild = entry.getValue();
                BoundedTrieNode thisChild = this.children.get(prefix);
                if (thisChild == null) {
                    this.children.put(prefix, otherChild);
                    delta += otherChild.size;
                    continue;
                }
                delta += thisChild.merge(otherChild);
            }
            this.size += delta;
            return delta;
        }

        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> flattened() {
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            if (this.truncated) {
                result.add(Collections.singletonList(TRUNCATED_TRUE));
            } else if (this.children.isEmpty()) {
                result.add(Collections.singletonList(TRUNCATED_FALSE));
            } else {
                ArrayList<String> prefixes = new ArrayList<String>(this.children.keySet());
                Collections.sort(prefixes);
                for (String prefix : prefixes) {
                    BoundedTrieNode child = this.children.get(prefix);
                    if (child == null) continue;
                    for (List<String> flattened : child.flattened()) {
                        ArrayList<String> newList = new ArrayList<String>();
                        newList.add(prefix);
                        newList.addAll(flattened);
                        result.add(newList);
                    }
                }
            }
            return result;
        }

        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized MetricsApi.BoundedTrieNode toProto() {
            MetricsApi.BoundedTrieNode.Builder builder = MetricsApi.BoundedTrieNode.newBuilder();
            builder.setTruncated(this.truncated);
            this.children.forEach((key, value) -> builder.putChildren(key, value.toProto()));
            return builder.build();
        }

        static @UnknownKeyFor @NonNull @Initialized BoundedTrieNode fromProto(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized MetricsApi.BoundedTrieNode proto) {
            BoundedTrieNode node = new BoundedTrieNode();
            if (proto.getTruncated()) {
                node.truncated = true;
                node.children = new HashMap<String, BoundedTrieNode>();
            } else {
                node.children = new HashMap<String, BoundedTrieNode>();
                proto.getChildrenMap().forEach((key, value) -> node.children.put((String)key, BoundedTrieNode.fromProto(value)));
                node.size = Math.max(1, node.children.values().stream().mapToInt(BoundedTrieNode::getSize).sum());
            }
            return node;
        }

        @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> segments) {
            if (this.truncated || segments.isEmpty()) {
                return true;
            }
            String head = segments.get(0);
            List<String> tail = segments.subList(1, segments.size());
            return this.children.containsKey(head) && this.children.get(head).contains(tail);
        }

        @UnknownKeyFor @NonNull @Initialized int getSize() {
            return this.size;
        }

        @UnknownKeyFor @NonNull @Initialized boolean isTruncated() {
            return this.truncated;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            int result = 17;
            result = 31 * result + this.size;
            result = 31 * result + this.children.hashCode();
            result = 31 * result + (this.truncated ? 1 : 0);
            return result;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BoundedTrieNode that = (BoundedTrieNode)other;
            return this.truncated == that.truncated && this.children.equals(that.children);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "{" + this.flattened().stream().map(list -> "'" + String.join((CharSequence)"", list) + "'").collect(Collectors.joining(", ")) + "}";
        }
    }
}

