/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.type;

import org.javaruntype.type.ExtendsTypeParameter;
import org.javaruntype.type.Type;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.WildcardTypeParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuperTypeParameter<T>
extends TypeParameter<T> {
    private static final long serialVersionUID = -1844549429272543154L;
    private final Type<T> type;
    private final String stringRepresentation;
    private final int hashCode;

    private static <T> String createStringRepresentation(Type<T> type) {
        return ("? super " + type.getName()).intern();
    }

    SuperTypeParameter(Type<T> type) {
        this.type = type;
        this.stringRepresentation = SuperTypeParameter.createStringRepresentation(type);
        this.hashCode = this.stringRepresentation.hashCode();
    }

    @Override
    public Type<T> getType() {
        return this.type;
    }

    @Override
    boolean isAssignableFrom(TypeParameter<?> typeParameter) {
        if (this.equals(typeParameter)) {
            return true;
        }
        if (typeParameter instanceof WildcardTypeParameter || typeParameter instanceof ExtendsTypeParameter) {
            return false;
        }
        return typeParameter.getType().isAssignableFrom(this.type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SuperTypeParameter other = (SuperTypeParameter)obj;
        return this.stringRepresentation.equals(other.stringRepresentation);
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

