/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.runners;

import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.junit.DefaultTestFinishedEvent;
import org.mockito.internal.junit.MockitoTestListener;
import org.mockito.internal.runners.InternalRunner;
import org.mockito.internal.util.Supplier;

public class DefaultInternalRunner
implements InternalRunner {
    private final BlockJUnit4ClassRunner runner;

    public DefaultInternalRunner(Class<?> testClass, final Supplier<MockitoTestListener> listenerSupplier) throws InitializationError {
        this.runner = new BlockJUnit4ClassRunner(testClass){
            public Object target;
            private MockitoTestListener mockitoTestListener;

            @Override
            protected Statement withBefores(FrameworkMethod method, final Object target, Statement statement) {
                this.target = target;
                final Statement base = super.withBefores(method, target, statement);
                return new Statement(){

                    @Override
                    public void evaluate() throws Throwable {
                        AutoCloseable closeable;
                        if (mockitoTestListener == null) {
                            mockitoTestListener = (MockitoTestListener)listenerSupplier.get();
                            Mockito.framework().addListener(mockitoTestListener);
                            closeable = MockitoAnnotations.openMocks(target);
                        } else {
                            closeable = null;
                        }
                        try {
                            base.evaluate();
                        }
                        finally {
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                    }
                };
            }

            @Override
            public void run(final RunNotifier notifier) {
                RunListener listener = new RunListener(){
                    Throwable failure;

                    @Override
                    public void testFailure(Failure failure) throws Exception {
                        this.failure = failure.getException();
                    }

                    @Override
                    public void testFinished(Description description) throws Exception {
                        try {
                            if (mockitoTestListener != null) {
                                Mockito.framework().removeListener(mockitoTestListener);
                                mockitoTestListener.testFinished(new DefaultTestFinishedEvent(target, description.getMethodName(), this.failure));
                                mockitoTestListener = null;
                            }
                            Mockito.validateMockitoUsage();
                        }
                        catch (Throwable t) {
                            notifier.fireTestFailure(new Failure(description, t));
                        }
                    }
                };
                notifier.addListener(listener);
                super.run(notifier);
            }
        };
    }

    @Override
    public void run(RunNotifier notifier) {
        this.runner.run(notifier);
    }

    @Override
    public Description getDescription() {
        return this.runner.getDescription();
    }

    @Override
    public void filter(Filter filter) throws NoTestsRemainException {
        this.runner.filter(filter);
    }
}

