/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.GenericDeclarationScope;
import ru.vyarus.java.generics.resolver.context.GenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.util.GenericsResolutionUtils;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;

public class ConstructorGenericsContext
extends GenericsContext {
    private final Constructor ctor;
    private Map<String, Type> constructorGenerics;
    private Map<String, Type> allGenerics;

    public ConstructorGenericsContext(GenericsInfo genericsInfo, Constructor constructor, GenericsContext root) {
        super(genericsInfo, constructor.getDeclaringClass(), root);
        this.ctor = constructor;
        this.initGenerics();
    }

    public Constructor currentConstructor() {
        return this.ctor;
    }

    public List<Type> constructorGenericTypes() {
        return this.constructorGenerics.isEmpty() ? Collections.emptyList() : new ArrayList<Type>(this.constructorGenerics.values());
    }

    public Map<String, Type> constructorGenericsMap() {
        return this.constructorGenerics.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, Type>(this.constructorGenerics);
    }

    public List<Class<?>> resolveParameters() {
        return GenericsUtils.resolveClasses(this.ctor.getGenericParameterTypes(), this.contextGenerics());
    }

    public List<Type> resolveParametersTypes() {
        return Arrays.asList(GenericsUtils.resolveTypeVariables(this.ctor.getGenericParameterTypes(), this.contextGenerics()));
    }

    public Type resolveParameterType(int pos) {
        this.checkParameter(pos);
        return this.resolveType(this.ctor.getGenericParameterTypes()[pos]);
    }

    public GenericsContext parameterType(int pos) {
        this.checkParameter(pos);
        return this.inlyingType(this.ctor.getGenericParameterTypes()[pos]);
    }

    public GenericsContext parameterTypeAs(int pos, Class<?> asType) {
        this.checkParameter(pos);
        return this.inlyingTypeAs(this.ctor.getGenericParameterTypes()[pos], asType);
    }

    public String toStringConstructor() {
        return TypeToStringUtils.toStringConstructor(this.ctor, this.contextGenerics());
    }

    @Override
    public String toString() {
        return this.genericsInfo.toStringHierarchy(new ConstructorContextWriter());
    }

    @Override
    public GenericDeclarationScope getGenericsScope() {
        return GenericDeclarationScope.CONSTRUCTOR;
    }

    @Override
    public GenericDeclaration getGenericsSource() {
        return this.currentConstructor();
    }

    @Override
    public ConstructorGenericsContext constructor(Constructor constructor) {
        return constructor == this.currentConstructor() ? this : super.constructor(constructor);
    }

    @Override
    protected Map<String, Type> contextGenerics() {
        return this.allGenerics;
    }

    private void initGenerics() {
        TypeVariable<Constructor<T>>[] constrGenerics = this.ctor.getTypeParameters();
        boolean hasConstrGenerics = constrGenerics.length > 0;
        Map<Object, Object> map = this.constructorGenerics = hasConstrGenerics ? GenericsResolutionUtils.resolveDirectRawGenerics(this.ctor, (Map<String, Type>)this.allTypeGenerics) : Collections.emptyMap();
        if (hasConstrGenerics) {
            this.allGenerics = new LinkedHashMap<String, Type>(this.allTypeGenerics);
            this.allGenerics.putAll(this.constructorGenerics);
        } else {
            this.allGenerics = this.allTypeGenerics;
        }
    }

    private void checkParameter(int pos) {
        Type[] genericParams = this.ctor.getGenericParameterTypes();
        if (pos < 0 || pos >= genericParams.length) {
            throw new IllegalArgumentException(String.format("Can't request parameter %s of constructor '%s' because it have only %s parameters", pos, this.toStringConstructor(), genericParams.length));
        }
    }

    class ConstructorContextWriter
    extends GenericsContext.RootContextAwareTypeWriter {
        ConstructorContextWriter() {
            super(ConstructorGenericsContext.this);
        }

        @Override
        public String write(Class<?> type, Map<String, Type> generics, Class<?> owner, Map<String, Type> ownerGenerics, String shift) {
            String method = "";
            if (type == ConstructorGenericsContext.this.currentType) {
                method = String.format("%n%s%s%s%s", shift, "  ", ConstructorGenericsContext.this.toStringConstructor(), "    <-- current");
            }
            return super.write(type, generics, owner, ownerGenerics, shift) + method;
        }
    }
}

