/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.fn.harness.Cache;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.StateBackedIterable;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.RemoteGrpcPortWrite;
import org.apache.beam.sdk.util.construction.CoderTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamFnDataWriteRunner<@UnknownKeyFor InputT> {

    static class Factory<@UnknownKeyFor InputT>
    implements PTransformRunnerFactory<BeamFnDataWriteRunner> {
        Factory() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BeamFnDataWriteRunner createRunnerForPTransform(final @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            BeamFnApi.RemoteGrpcPort port = RemoteGrpcPortWrite.fromPTransform((RunnerApi.PTransform)context.getPTransform()).getPort();
            RehydratedComponents components = RehydratedComponents.forComponents((RunnerApi.Components)context.getComponents());
            Coder coder = CoderTranslation.fromProto((RunnerApi.Coder)((RunnerApi.Coder)context.getComponents().getCodersMap().get(port.getCoderId())), (RehydratedComponents)components, (CoderTranslation.TranslationContext)new StateBackedIterable.StateBackedIterableTranslationContext(){

                @Override
                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCache() {
                    return context.getBundleCacheSupplier();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized BeamFnStateClient getStateClient() {
                    return context.getBeamFnStateClient();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized String> getCurrentInstructionId() {
                    return context.getProcessBundleInstructionIdSupplier();
                }
            });
            context.addPCollectionConsumer((String)Iterables.getOnlyElement(context.getPTransform().getInputsMap().values()), context.addOutgoingDataEndpoint(port.getApiServiceDescriptor(), coder));
            return new BeamFnDataWriteRunner();
        }
    }

    @AutoService(value={PTransformRunnerFactory.Registrar.class})
    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory> getPTransformRunnerFactories() {
            return ImmutableMap.of((Object)"beam:runner:sink:v1", new Factory());
        }
    }
}

