/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class SerializablePipelineOptions
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    private final @UnknownKeyFor @NonNull @Initialized String serializedPipelineOptions;
    private transient @UnknownKeyFor @NonNull @Initialized PipelineOptions options;

    public SerializablePipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.serializedPipelineOptions = SerializablePipelineOptions.serializeToJson(options);
        this.options = options;
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
    }

    public SerializablePipelineOptions(@UnknownKeyFor @NonNull @Initialized String json) {
        this.serializedPipelineOptions = json;
        this.options = SerializablePipelineOptions.deserializeFromJson(json);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.options);
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineOptions get() {
        return this.options;
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        is.defaultReadObject();
        this.options = SerializablePipelineOptions.deserializeFromJson(this.serializedPipelineOptions);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.options);
    }

    private static @UnknownKeyFor @NonNull @Initialized String serializeToJson(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        try {
            return MAPPER.writeValueAsString((Object)options);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize PipelineOptions", e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized PipelineOptions deserializeFromJson(@UnknownKeyFor @NonNull @Initialized String options) {
        try {
            return (PipelineOptions)MAPPER.readValue(options, PipelineOptions.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize PipelineOptions", e);
        }
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.serializedPipelineOptions;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializablePipelineOptions that = (SerializablePipelineOptions)o;
        return this.serializedPipelineOptions.equals(that.serializedPipelineOptions);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.serializedPipelineOptions, this.options);
    }
}

