/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.model.Message;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedReader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class SqsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private final List<Message> messagesToDelete;
    private final transient Optional<SqsUnboundedReader> reader;

    public SqsCheckpointMark(SqsUnboundedReader reader, Collection<Message> messagesToDelete) {
        this.reader = Optional.of(reader);
        this.messagesToDelete = ImmutableList.copyOf(messagesToDelete);
    }

    public void finalizeCheckpoint() {
        this.reader.ifPresent(r -> r.delete(this.messagesToDelete));
    }

    List<Message> getMessagesToDelete() {
        return this.messagesToDelete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsCheckpointMark that = (SqsCheckpointMark)o;
        return Objects.equal(this.messagesToDelete, that.messagesToDelete);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.messagesToDelete});
    }
}

