/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.options;

import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import org.apache.beam.sdk.io.aws.options.AwsOptions;
import org.apache.beam.sdk.io.aws.options.S3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws.s3.DefaultS3ClientBuilderFactory;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface S3Options
extends AwsOptions {
    @Description(value="AWS S3 storage class used for creating S3 objects")
    @Default.String(value="STANDARD")
    public String getS3StorageClass();

    public void setS3StorageClass(String var1);

    @Description(value="Size of S3 upload chunks; max upload object size is this value multiplied by 10000;default is 64MB, or 5MB in memory-constrained environments. Must be at least 5MB.")
    @Default.InstanceFactory(value=S3UploadBufferSizeBytesFactory.class)
    public Integer getS3UploadBufferSizeBytes();

    public void setS3UploadBufferSizeBytes(Integer var1);

    @Description(value="Thread pool size, limiting max concurrent S3 operations")
    @Default.Integer(value=50)
    public int getS3ThreadPoolSize();

    public void setS3ThreadPoolSize(int var1);

    @Description(value="Algorithm for SSE-S3 encryption, e.g. AES256.")
    public @Nullable String getSSEAlgorithm();

    public void setSSEAlgorithm(String var1);

    @Description(value="SSE key for SSE-C encryption, e.g. a base64 encoded key and the algorithm.To specify on the command-line, represent the value as a JSON object. For example: --SSECustomerKey={\"key\": \"86glyTlCN...\", \"algorithm\": \"AES256\"}")
    public @Nullable SSECustomerKey getSSECustomerKey();

    public void setSSECustomerKey(SSECustomerKey var1);

    @Description(value="KMS key id for SSE-KMS encryption, e.g. \"arn:aws:kms:...\".To specify on the command-line, represent the value as a JSON object. For example: --SSEAwsKeyManagementParams={\"awsKmsKeyId\": \"arn:aws:kms:...\"}")
    public @Nullable SSEAwsKeyManagementParams getSSEAwsKeyManagementParams();

    public void setSSEAwsKeyManagementParams(SSEAwsKeyManagementParams var1);

    @Description(value="Factory class that should be created and used to create a builder of AmazonS3 client.Override the default value if you need a S3 client with custom properties, like path style access, etc.")
    @Default.Class(value=DefaultS3ClientBuilderFactory.class)
    public Class<? extends S3ClientBuilderFactory> getS3ClientFactoryClass();

    public void setS3ClientFactoryClass(Class<? extends S3ClientBuilderFactory> var1);

    public static class S3UploadBufferSizeBytesFactory
    implements DefaultValueFactory<Integer> {
        public static final int MINIMUM_UPLOAD_BUFFER_SIZE_BYTES = 0x500000;

        public Integer create(PipelineOptions options) {
            return Runtime.getRuntime().maxMemory() < 0x20000000L ? 0x500000 : 0x4000000;
        }
    }
}

