/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws.sqs.SqsConfiguration;
import org.apache.beam.sdk.io.aws.sqs.SqsIO;
import org.apache.beam.sdk.io.aws.sqs.SqsUnboundedReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import org.checkerframework.checker.nullness.qual.Nullable;

class SqsUnboundedSource
extends UnboundedSource<Message, SqsCheckpointMark> {
    private final SqsIO.Read read;
    private final SqsConfiguration sqsConfiguration;
    private final Supplier<AmazonSQS> sqs;

    public SqsUnboundedSource(SqsIO.Read read, SqsConfiguration sqsConfiguration) {
        this.read = read;
        this.sqsConfiguration = sqsConfiguration;
        this.sqs = Suppliers.memoize((Supplier & Serializable)() -> (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withClientConfiguration(sqsConfiguration.getClientConfiguration())).withCredentials(sqsConfiguration.getAwsCredentialsProvider())).withRegion(sqsConfiguration.getAwsRegion())).build());
    }

    public List<SqsUnboundedSource> split(int desiredNumSplits, PipelineOptions options) {
        ArrayList<SqsUnboundedSource> sources = new ArrayList<SqsUnboundedSource>();
        for (int i = 0; i < Math.max(1, desiredNumSplits); ++i) {
            sources.add(new SqsUnboundedSource(this.read, this.sqsConfiguration));
        }
        return sources;
    }

    public UnboundedSource.UnboundedReader<Message> createReader(PipelineOptions options, @Nullable SqsCheckpointMark checkpointMark) {
        return new SqsUnboundedReader(this, checkpointMark);
    }

    public Coder<SqsCheckpointMark> getCheckpointMarkCoder() {
        return SerializableCoder.of(SqsCheckpointMark.class);
    }

    public Coder<Message> getOutputCoder() {
        return SerializableCoder.of(Message.class);
    }

    public SqsIO.Read getRead() {
        return this.read;
    }

    public AmazonSQS getSqs() {
        return (AmazonSQS)this.sqs.get();
    }

    public boolean requiresDeduping() {
        return true;
    }
}

