/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_io_amazon_web_services.com.google.common.base.Optional;
import org.apache.beam.repackaged.beam_sdks_java_io_amazon_web_services.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_io_amazon_web_services.com.google.common.base.Strings;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;

class S3ResourceId
implements ResourceId {
    static final String SCHEME = "s3";
    private static final Pattern S3_URI = Pattern.compile("(?<SCHEME>[^:]+)://(?<BUCKET>[^/]+)(/(?<KEY>.*))?");
    private static final Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");
    private final String bucket;
    private final String key;
    private final Long size;

    private S3ResourceId(String bucket, String key, @Nullable Long size) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(bucket), "bucket");
        this.bucket = bucket;
        this.key = Preconditions.checkNotNull(key, "key");
        this.size = size;
    }

    static S3ResourceId fromComponents(String bucket, String key) {
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        return new S3ResourceId(bucket, key, null);
    }

    static S3ResourceId fromUri(String uri) {
        Matcher m = S3_URI.matcher(uri);
        Preconditions.checkArgument(m.matches(), "Invalid S3 URI: [%s]", (Object)uri);
        Preconditions.checkArgument(m.group("SCHEME").equalsIgnoreCase(SCHEME), "Invalid S3 URI scheme: [%s]", (Object)uri);
        String bucket = m.group("BUCKET");
        String key = Strings.nullToEmpty(m.group("KEY"));
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        return S3ResourceId.fromComponents(bucket, key);
    }

    String getBucket() {
        return this.bucket;
    }

    String getKey() {
        return this.key.substring(1);
    }

    Optional<Long> getSize() {
        return Optional.fromNullable(this.size);
    }

    S3ResourceId withSize(long size) {
        return new S3ResourceId(this.bucket, this.key, size);
    }

    public ResourceId resolve(String other, ResolveOptions resolveOptions) {
        Preconditions.checkState(this.isDirectory(), "Expected this resource to be a directory, but was [%s]", (Object)this.toString());
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) {
            if ("..".equals(other)) {
                if ("/".equals(this.key)) {
                    return this;
                }
                int parentStopsAt = this.key.substring(0, this.key.length() - 1).lastIndexOf(47);
                return S3ResourceId.fromComponents(this.bucket, this.key.substring(0, parentStopsAt + 1));
            }
            if ("".equals(other)) {
                return this;
            }
            if (!other.endsWith("/")) {
                other = other + "/";
            }
            if (S3_URI.matcher(other).matches()) {
                return S3ResourceId.fromUri(other);
            }
            return S3ResourceId.fromComponents(this.bucket, this.key + other);
        }
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_FILE) {
            Preconditions.checkArgument(!other.endsWith("/"), "Cannot resolve a file with a directory path: [%s]", (Object)other);
            Preconditions.checkArgument(!"..".equals(other), "Cannot resolve parent as file: [%s]", (Object)other);
            if (S3_URI.matcher(other).matches()) {
                return S3ResourceId.fromUri(other);
            }
            return S3ResourceId.fromComponents(this.bucket, this.key + other);
        }
        throw new UnsupportedOperationException(String.format("Unexpected StandardResolveOptions [%s]", resolveOptions));
    }

    public ResourceId getCurrentDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        return S3ResourceId.fromComponents(this.getBucket(), this.key.substring(0, this.key.lastIndexOf(47) + 1));
    }

    public String getScheme() {
        return SCHEME;
    }

    @Nullable
    public String getFilename() {
        if (!this.isDirectory()) {
            return this.key.substring(this.key.lastIndexOf(47) + 1);
        }
        if ("/".equals(this.key)) {
            return null;
        }
        String keyWithoutTrailingSlash = this.key.substring(0, this.key.length() - 1);
        return keyWithoutTrailingSlash.substring(keyWithoutTrailingSlash.lastIndexOf(47) + 1);
    }

    public boolean isDirectory() {
        return this.key.endsWith("/");
    }

    boolean isWildcard() {
        return GLOB_PREFIX.matcher(this.getKey()).matches();
    }

    String getKeyNonWildcardPrefix() {
        Matcher m = GLOB_PREFIX.matcher(this.getKey());
        Preconditions.checkArgument(m.matches(), String.format("Glob expression: [%s] is not expandable.", this.getKey()));
        return m.group("PREFIX");
    }

    public String toString() {
        return String.format("%s://%s%s", SCHEME, this.bucket, this.key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof S3ResourceId)) {
            return false;
        }
        return this.bucket.equals(((S3ResourceId)obj).bucket) && this.key.equals(((S3ResourceId)obj).key);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.key);
    }
}

