/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_io_amazon_web_services.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_sdks_java_io_amazon_web_services.com.google.common.base.Preconditions;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;

class S3WritableByteChannel
implements WritableByteChannel {
    private final AmazonS3 amazonS3;
    private final S3Options options;
    private final S3ResourceId path;
    private final String uploadId;
    private final ByteBuffer uploadBuffer;
    private final List<PartETag> eTags;
    private int partNumber = 1;
    private boolean open = true;

    S3WritableByteChannel(AmazonS3 amazonS3, S3ResourceId path, String contentType, S3Options options) throws IOException {
        InitiateMultipartUploadResult result;
        this.amazonS3 = Preconditions.checkNotNull(amazonS3, "amazonS3");
        this.options = Preconditions.checkNotNull(options);
        this.path = Preconditions.checkNotNull(path, "path");
        Preconditions.checkArgument(S3WritableByteChannel.atMostOne(options.getSSECustomerKey() != null, options.getSSEAlgorithm() != null, options.getSSEAwsKeyManagementParams() != null), "Either SSECustomerKey (SSE-C) or SSEAlgorithm (SSE-S3) or SSEAwsKeyManagementParams (SSE-KMS) must not be set at the same time.");
        Preconditions.checkArgument(options.getS3UploadBufferSizeBytes() >= 0x500000, "S3UploadBufferSizeBytes must be at least %s bytes", 0x500000);
        this.uploadBuffer = ByteBuffer.allocate(options.getS3UploadBufferSizeBytes());
        this.eTags = new ArrayList<PartETag>();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        if (options.getSSEAlgorithm() != null) {
            objectMetadata.setSSEAlgorithm(options.getSSEAlgorithm());
        }
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(path.getBucket(), path.getKey()).withStorageClass(options.getS3StorageClass()).withObjectMetadata(objectMetadata);
        request.setSSECustomerKey(options.getSSECustomerKey());
        request.setSSEAwsKeyManagementParams(options.getSSEAwsKeyManagementParams());
        try {
            result = amazonS3.initiateMultipartUpload(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        this.uploadId = result.getUploadId();
    }

    @Override
    public int write(ByteBuffer sourceBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int totalBytesWritten = 0;
        while (sourceBuffer.hasRemaining()) {
            int bytesWritten = Math.min(sourceBuffer.remaining(), this.uploadBuffer.remaining());
            totalBytesWritten += bytesWritten;
            byte[] copyBuffer = new byte[bytesWritten];
            sourceBuffer.get(copyBuffer);
            this.uploadBuffer.put(copyBuffer);
            if (this.uploadBuffer.hasRemaining() && !sourceBuffer.hasRemaining()) continue;
            this.flush();
        }
        return totalBytesWritten;
    }

    private void flush() throws IOException {
        UploadPartResult result;
        this.uploadBuffer.flip();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.uploadBuffer.array());
        UploadPartRequest request = new UploadPartRequest().withBucketName(this.path.getBucket()).withKey(this.path.getKey()).withUploadId(this.uploadId).withPartNumber(this.partNumber++).withPartSize((long)this.uploadBuffer.remaining()).withInputStream((InputStream)inputStream);
        request.setSSECustomerKey(this.options.getSSECustomerKey());
        try {
            result = this.amazonS3.uploadPart(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        this.uploadBuffer.clear();
        this.eTags.add(result.getPartETag());
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (this.uploadBuffer.remaining() > 0) {
            this.flush();
        }
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest().withBucketName(this.path.getBucket()).withKey(this.path.getKey()).withUploadId(this.uploadId).withPartETags(this.eTags);
        try {
            this.amazonS3.completeMultipartUpload(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    static boolean atMostOne(boolean ... values) {
        boolean one = false;
        for (boolean value : values) {
            if (!one && value) {
                one = true;
                continue;
            }
            if (!value) continue;
            return false;
        }
        return true;
    }
}

