/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import java.io.Serializable;
import java.net.URI;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.common.;
import org.apache.beam.sdk.io.aws2.common.RetryConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsSerializableUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ClientConfiguration
implements Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized ClientConfiguration EMPTY = ClientConfiguration.builder().build();

    @JsonProperty
    @Nullable
    @Pure
    @Memoized
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProviderAsJson() != null ? AwsSerializableUtils.deserializeAwsCredentialsProvider(this.credentialsProviderAsJson()) : null;
    }

    @JsonProperty
    @Nullable
    @Pure
    @Memoized
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Region region() {
        return this.regionId() != null ? Region.of((String)this.regionId()) : null;
    }

    @JsonProperty
    @Nullable
    @Pure
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized URI endpoint();

    @JsonProperty
    @Nullable
    @Pure
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryConfiguration retry();

    @Nullable
    @Pure
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String regionId();

    @Nullable
    @Pure
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String credentialsProviderAsJson();

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return Builder.builder();
    }

    public static @UnknownKeyFor @NonNull @Initialized ClientConfiguration create(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentials, @UnknownKeyFor @NonNull @Initialized Region region, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized URI endpoint) {
        Builder builder = ClientConfiguration.builder().credentialsProvider(credentials).region(region);
        if (endpoint != null) {
            builder.endpoint(endpoint);
        }
        return builder.build();
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new .AutoValue_ClientConfiguration.Builder();
        }

        public @UnknownKeyFor @NonNull @Initialized Builder credentialsProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider) {
            return this.credentialsProviderAsJson(AwsSerializableUtils.serializeAwsCredentialsProvider(credentialsProvider));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder region(@UnknownKeyFor @NonNull @Initialized Region region) {
            return this.regionId(region.id());
        }

        public abstract @UnknownKeyFor @NonNull @Initialized Builder endpoint(@UnknownKeyFor @NonNull @Initialized URI var1);

        @JsonSetter
        public abstract @UnknownKeyFor @NonNull @Initialized Builder retry(@UnknownKeyFor @NonNull @Initialized RetryConfiguration var1);

        public @UnknownKeyFor @NonNull @Initialized Builder retry(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized RetryConfiguration.Builder> retry) {
            RetryConfiguration.Builder builder = RetryConfiguration.builder();
            retry.accept(builder);
            return this.retry(builder.build());
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder regionId(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder credentialsProviderAsJson(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration build();
    }
}

