/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardFilter;
import software.amazon.awssdk.services.kinesis.model.ShardFilterType;
import software.amazon.awssdk.services.kinesis.model.StreamDescriptionSummary;
import software.amazon.kinesis.common.InitialPositionInStream;

class ShardListingUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ShardListingUtils.class);
    private static final @UnknownKeyFor @NonNull @Initialized int LIST_SHARDS_MAX_RESULTS = 1000;
    private static final @UnknownKeyFor @NonNull @Initialized Duration SPACING_FOR_TIMESTAMP_LIST_SHARDS_REQUEST_TO_NOT_EXCEED_TRIM_HORIZON = Duration.standardMinutes((long)5L);
    private static final @UnknownKeyFor @NonNull @Initialized int DESCRIBE_STREAM_SUMMARY_MAX_ATTEMPTS = 10;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DESCRIBE_STREAM_SUMMARY_INITIAL_BACKOFF = Duration.standardSeconds((long)1L);

    ShardListingUtils() {
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Shard> listShardsAtPoint(@UnknownKeyFor @NonNull @Initialized KinesisClient kinesisClient, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        ShardFilter shardFilter = ShardListingUtils.buildShardFilterForStartingPoint(kinesisClient, streamName, startingPoint);
        return ShardListingUtils.listShards(kinesisClient, streamName, shardFilter);
    }

    static @UnknownKeyFor @NonNull @Initialized ShardFilter buildShardFilterForStartingPoint(@UnknownKeyFor @NonNull @Initialized KinesisClient kinesisClient, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        InitialPositionInStream position = startingPoint.getPosition();
        switch (position) {
            case LATEST: {
                return (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_LATEST).build();
            }
            case TRIM_HORIZON: {
                return (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TRIM_HORIZON).build();
            }
            case AT_TIMESTAMP: {
                return ShardListingUtils.buildShardFilterForTimestamp(kinesisClient, streamName, startingPoint.getTimestamp());
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized '%s' position to create shard filter with", position));
    }

    private static @UnknownKeyFor @NonNull @Initialized ShardFilter buildShardFilterForTimestamp(@UnknownKeyFor @NonNull @Initialized KinesisClient kinesisClient, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Instant startingPointTimestamp) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        StreamDescriptionSummary streamDescription = ShardListingUtils.describeStreamSummary(kinesisClient, streamName);
        Instant streamCreationTimestamp = TimeUtil.toJoda(streamDescription.streamCreationTimestamp());
        if (streamCreationTimestamp.isAfter((ReadableInstant)startingPointTimestamp)) {
            return (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TRIM_HORIZON).build();
        }
        Duration retentionPeriod = Duration.standardHours((long)streamDescription.retentionPeriodHours().intValue());
        Instant streamTrimHorizonTimestamp = Instant.now().minus((ReadableDuration)retentionPeriod).plus((ReadableDuration)SPACING_FOR_TIMESTAMP_LIST_SHARDS_REQUEST_TO_NOT_EXCEED_TRIM_HORIZON);
        if (startingPointTimestamp.isAfter((ReadableInstant)streamTrimHorizonTimestamp)) {
            return (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TIMESTAMP).timestamp(TimeUtil.toJava(startingPointTimestamp)).build();
        }
        return (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TRIM_HORIZON).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized StreamDescriptionSummary describeStreamSummary(@UnknownKeyFor @NonNull @Initialized KinesisClient kinesisClient, @UnknownKeyFor @NonNull @Initialized String streamName) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        FluentBackoff retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(10).withInitialBackoff(DESCRIBE_STREAM_SUMMARY_INITIAL_BACKOFF);
        BackOff backoff = retryBackoff.backoff();
        Sleeper sleeper = Sleeper.DEFAULT;
        DescribeStreamSummaryRequest request = (DescribeStreamSummaryRequest)DescribeStreamSummaryRequest.builder().streamName(streamName).build();
        while (true) {
            try {
                LOG.debug("Executing request: {}", (Object)request);
                return kinesisClient.describeStreamSummary(request).streamDescriptionSummary();
            }
            catch (LimitExceededException exc) {
                if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) continue;
                throw exc;
            }
            break;
        }
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Shard> listShards(@UnknownKeyFor @NonNull @Initialized KinesisClient kinesisClient, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized ShardFilter shardFilter) {
        ListShardsResponse response;
        ImmutableList.Builder shardsBuilder = ImmutableList.builder();
        String currentNextToken = null;
        do {
            ListShardsRequest.Builder reqBuilder = ListShardsRequest.builder().maxResults(Integer.valueOf(1000)).shardFilter(shardFilter);
            if (currentNextToken != null) {
                reqBuilder.nextToken(currentNextToken);
            } else {
                reqBuilder.streamName(streamName);
            }
            ListShardsRequest request = (ListShardsRequest)reqBuilder.build();
            LOG.debug("Executing request: {}", (Object)request);
            response = kinesisClient.listShards(request);
            shardsBuilder.addAll((Iterable)response.shards());
        } while ((currentNextToken = response.nextToken()) != null);
        return shardsBuilder.build();
    }
}

