/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.aws2.options.AwsModule;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

@Internal
public class AwsSerializableUtils {
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper();

    public static @UnknownKeyFor @NonNull @Initialized String serializeAwsCredentialsProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider) {
        return AwsSerializableUtils.serialize(credentialsProvider);
    }

    public static @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider deserializeAwsCredentialsProvider(@UnknownKeyFor @NonNull @Initialized String serializedCredentialsProvider) {
        return AwsSerializableUtils.deserialize(serializedCredentialsProvider, AwsCredentialsProvider.class);
    }

    static @UnknownKeyFor @NonNull @Initialized String serialize(@UnknownKeyFor @NonNull @Initialized Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(object.getClass().getSimpleName() + " can not be serialized to Json", e);
        }
    }

    static <T> T deserialize(@UnknownKeyFor @NonNull @Initialized String serializedObject, @UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(serializedObject, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " can not be deserialized from Json", e);
        }
    }

    static {
        MAPPER.registerModule((Module)new AwsModule());
    }
}

