/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.schemas;

import java.util.function.BiConsumer;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.io.aws2.schemas.AwsBuilderFactory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.builder.SdkBuilder;

class AwsSchemaUtils {
    private static final @UnknownKeyFor @NonNull @Initialized ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescription FACTORY_TYPE = TypeDescription.ForLoadedType.of(AwsBuilderFactory.class);

    private AwsSchemaUtils() {
    }

    static <PojoT extends SdkPojo, BuilderT extends SdkBuilder<BuilderT, PojoT> & SdkPojo> @UnknownKeyFor @NonNull @Initialized AwsBuilderFactory<PojoT, BuilderT> builderFactory(@UnknownKeyFor @NonNull @Initialized Class<PojoT> clazz) {
        TypeDescription.Generic pojoType = new TypeDescription.ForLoadedType(clazz).asGenericType();
        MethodDescription builderMethod = (MethodDescription)((MethodList)pojoType.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"builder").and((ElementMatcher)ElementMatchers.isStatic()))).getOnly();
        TypeDescription.Generic providerType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)FACTORY_TYPE, (TypeDefinition[])new TypeDefinition[]{pojoType, builderMethod.getReturnType()}).build();
        try {
            return (AwsBuilderFactory)BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass((TypeDefinition)providerType).method((ElementMatcher)ElementMatchers.named((String)"get")).intercept((Implementation)MethodCall.invoke((MethodDescription)builderMethod)).make().load(ReflectHelpers.findClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to generate builder factory for " + clazz, e);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized SdkBuilderSetter setter(@UnknownKeyFor @NonNull @Initialized String name, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized SdkBuilder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Object> setter) {
        return new ValueSetter(name, setter);
    }

    static <ObjT, ValT> @UnknownKeyFor @NonNull @Initialized FieldValueGetter<ObjT, ValT> getter(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ObjT, ValT> getter) {
        return new ValueGetter<ObjT, ValT>(name, getter);
    }

    private static class ValueGetter<@UnknownKeyFor ObjT, @UnknownKeyFor ValT>
    implements FieldValueGetter<ObjT, ValT> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<ObjT, ValT> getter;
        private final @UnknownKeyFor @NonNull @Initialized String name;

        ValueGetter(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<ObjT, ValT> getter) {
            this.name = name;
            this.getter = getter;
        }

        public @Nullable ValT get(ObjT object) {
            return (ValT)this.getter.apply(object);
        }

        public @UnknownKeyFor @NonNull @Initialized String name() {
            return this.name;
        }
    }

    private static class ValueSetter
    implements SdkBuilderSetter {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized SdkBuilder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Object> setter;
        private final @UnknownKeyFor @NonNull @Initialized String name;

        ValueSetter(@UnknownKeyFor @NonNull @Initialized String name, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @NonNull @Initialized SdkBuilder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Object> setter) {
            this.name = name;
            this.setter = setter;
        }

        public void set(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SdkBuilder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> builder, @Nullable @UnknownKeyFor @Initialized Object value) {
            if (value != null) {
                this.setter.accept(builder, value);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized String name() {
            return this.name;
        }
    }

    static interface SdkBuilderSetter
    extends FieldValueSetter<SdkBuilder<?, ?>, Object> {
    }
}

