/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import software.amazon.kinesis.retrieval.KinesisClientRecord;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class KinesisRecord {
    private @UnknownKeyFor @NonNull @Initialized Instant readTime;
    private @UnknownKeyFor @NonNull @Initialized String streamName;
    private @UnknownKeyFor @NonNull @Initialized String shardId;
    private @UnknownKeyFor @NonNull @Initialized long subSequenceNumber;
    private @UnknownKeyFor @NonNull @Initialized String sequenceNumber;
    private @UnknownKeyFor @NonNull @Initialized Instant approximateArrivalTimestamp;
    private @UnknownKeyFor @NonNull @Initialized ByteBuffer data;
    private @UnknownKeyFor @NonNull @Initialized String partitionKey;

    public KinesisRecord(@UnknownKeyFor @NonNull @Initialized KinesisClientRecord record, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId) {
        this(record.data(), record.sequenceNumber(), record.subSequenceNumber(), record.partitionKey(), TimeUtil.toJoda(record.approximateArrivalTimestamp()), Instant.now(), streamName, shardId);
    }

    public KinesisRecord(@UnknownKeyFor @NonNull @Initialized ByteBuffer data, @UnknownKeyFor @NonNull @Initialized String sequenceNumber, @UnknownKeyFor @NonNull @Initialized long subSequenceNumber, @UnknownKeyFor @NonNull @Initialized String partitionKey, @UnknownKeyFor @NonNull @Initialized Instant approximateArrivalTimestamp, @UnknownKeyFor @NonNull @Initialized Instant readTime, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized String shardId) {
        this.data = this.copyData(data);
        this.sequenceNumber = sequenceNumber;
        this.subSequenceNumber = subSequenceNumber;
        this.partitionKey = partitionKey;
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        this.readTime = readTime;
        this.streamName = streamName;
        this.shardId = shardId;
    }

    private @UnknownKeyFor @NonNull @Initialized ByteBuffer copyData(@UnknownKeyFor @NonNull @Initialized ByteBuffer data) {
        data.rewind();
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        return ByteBuffer.wrap(bytes);
    }

    public @UnknownKeyFor @NonNull @Initialized ExtendedSequenceNumber getExtendedSequenceNumber() {
        return new ExtendedSequenceNumber(this.getSequenceNumber(), Long.valueOf(this.getSubSequenceNumber()));
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getUniqueId() {
        return this.getExtendedSequenceNumber().toString().getBytes(StandardCharsets.UTF_8);
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getReadTime() {
        return this.readTime;
    }

    public @UnknownKeyFor @NonNull @Initialized String getStreamName() {
        return this.streamName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getShardId() {
        return this.shardId;
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getDataAsBytes() {
        return this.getData().array();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public @UnknownKeyFor @NonNull @Initialized long getSubSequenceNumber() {
        return this.subSequenceNumber;
    }

    public @UnknownKeyFor @NonNull @Initialized String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getApproximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteBuffer getData() {
        return this.data;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPartitionKey() {
        return this.partitionKey;
    }
}

