/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisClientThrottledException;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicy;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RateLimitPolicyFactory
extends Serializable {
    public @UnknownKeyFor @NonNull @Initialized RateLimitPolicy getRateLimitPolicy();

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withoutLimiter() {
        return () -> new RateLimitPolicy(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withDefaultRateLimiter() {
        return RateLimitPolicyFactory.withDefaultRateLimiter(Duration.millis((long)100L), Duration.millis((long)500L), Duration.standardSeconds((long)1L));
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withDefaultRateLimiter(@UnknownKeyFor @NonNull @Initialized Duration emptySuccessBaseDelay, @UnknownKeyFor @NonNull @Initialized Duration throttledBaseDelay, @UnknownKeyFor @NonNull @Initialized Duration maxDelay) {
        return () -> new DefaultRateLimiter(emptySuccessBaseDelay, throttledBaseDelay, maxDelay);
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withFixedDelay() {
        return DelayIntervalRateLimiter::new;
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withFixedDelay(@UnknownKeyFor @NonNull @Initialized Duration delay) {
        return () -> new DelayIntervalRateLimiter(() -> delay);
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withDelay(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay) {
        return () -> new DelayIntervalRateLimiter(delay);
    }

    public static class DefaultRateLimiter
    implements RateLimitPolicy {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DefaultRateLimiter.class);
        private final @UnknownKeyFor @NonNull @Initialized Sleeper sleeper;
        private final @UnknownKeyFor @NonNull @Initialized BackOff emptySuccess;
        private final @UnknownKeyFor @NonNull @Initialized BackOff throttled;

        @VisibleForTesting
        DefaultRateLimiter(@UnknownKeyFor @NonNull @Initialized BackOff emptySuccess, @UnknownKeyFor @NonNull @Initialized BackOff throttled, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) {
            this.emptySuccess = emptySuccess;
            this.throttled = throttled;
            this.sleeper = sleeper;
        }

        public DefaultRateLimiter(@UnknownKeyFor @NonNull @Initialized BackOff emptySuccess, @UnknownKeyFor @NonNull @Initialized BackOff throttled) {
            this(emptySuccess, throttled, Sleeper.DEFAULT);
        }

        public DefaultRateLimiter(@UnknownKeyFor @NonNull @Initialized Duration emptySuccessBaseDelay, @UnknownKeyFor @NonNull @Initialized Duration throttledBaseDelay, @UnknownKeyFor @NonNull @Initialized Duration maxDelay) {
            this(FluentBackoff.DEFAULT.withInitialBackoff(emptySuccessBaseDelay).withMaxBackoff(maxDelay).backoff(), FluentBackoff.DEFAULT.withInitialBackoff(throttledBaseDelay).withMaxBackoff(maxDelay).backoff());
        }

        @Override
        public void onSuccess(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisRecord> records) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            try {
                if (records.isEmpty()) {
                    BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.emptySuccess);
                } else {
                    this.emptySuccess.reset();
                }
                this.throttled.reset();
            }
            catch (IOException e) {
                LOG.warn("Error applying onSuccess rate limit policy", (Throwable)e);
            }
        }

        @Override
        public void onThrottle(@UnknownKeyFor @NonNull @Initialized KinesisClientThrottledException e) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            try {
                BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.throttled);
            }
            catch (IOException ioe) {
                LOG.warn("Error applying onThrottle rate limit policy", (Throwable)e);
            }
        }
    }

    public static class DelayIntervalRateLimiter
    implements RateLimitPolicy {
        private static final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> DEFAULT_DELAY = () -> Duration.standardSeconds((long)1L);
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay;

        public DelayIntervalRateLimiter() {
            this(DEFAULT_DELAY);
        }

        public DelayIntervalRateLimiter(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay) {
            this.delay = delay;
        }

        @Override
        public void onSuccess(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisRecord> records) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            Thread.sleep(this.delay.get().getMillis());
        }
    }
}

